/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.analyzer.beans;

import java.util.ArrayList;
import java.util.List;
import org.eobjects.analyzer.beans.BooleanAnalyzer;
import org.eobjects.analyzer.beans.BooleanAnalyzerResult;
import org.eobjects.analyzer.beans.api.Alias;
import org.eobjects.analyzer.beans.api.Analyzer;
import org.eobjects.analyzer.beans.api.AnalyzerBean;
import org.eobjects.analyzer.beans.api.Categorized;
import org.eobjects.analyzer.beans.api.Configured;
import org.eobjects.analyzer.beans.api.Description;
import org.eobjects.analyzer.beans.api.Initialize;
import org.eobjects.analyzer.beans.api.OutputColumns;
import org.eobjects.analyzer.beans.api.Validate;
import org.eobjects.analyzer.beans.categories.ValidationCategory;
import org.eobjects.analyzer.beans.convert.ConvertToStringTransformer;
import org.eobjects.analyzer.beans.transform.DictionaryMatcherTransformer;
import org.eobjects.analyzer.beans.transform.StringPatternMatcherTransformer;
import org.eobjects.analyzer.data.InputColumn;
import org.eobjects.analyzer.data.InputRow;
import org.eobjects.analyzer.data.MockInputColumn;
import org.eobjects.analyzer.data.MockInputRow;
import org.eobjects.analyzer.reference.Dictionary;
import org.eobjects.analyzer.reference.StringPattern;
import org.eobjects.analyzer.reference.SynonymCatalog;

@AnalyzerBean(value="Reference data matcher")
@Alias(value={"Matching analyzer"})
@Description(value="Check your data values against multiple forms of reference data in one simple analyzer step.\nThis analyzer provides a handy shortcut for doing matching with dictionaries, synonym lookups or string patterns matching, retrieving matching matrices for all matches.")
@Categorized(value={ValidationCategory.class})
public class ReferenceDataMatcherAnalyzer
implements Analyzer<BooleanAnalyzerResult> {
    @Configured(order=1)
    InputColumn<?>[] columns;
    @Configured(order=2, required=false)
    Dictionary[] dictionaries;
    @Configured(order=3, required=false)
    SynonymCatalog[] synonymCatalogs;
    @Configured(order=4, required=false)
    StringPattern[] stringPatterns;
    private BooleanAnalyzer _booleanAnalyzer;
    private DictionaryMatcherTransformer[] _dictionaryMatchers;
    private StringPatternMatcherTransformer[] _stringPatternMatchers;
    private List<InputColumn<Boolean>> _matchColumns;

    public ReferenceDataMatcherAnalyzer(InputColumn<?>[] columns, Dictionary[] dictionaries, SynonymCatalog[] synonymCatalogs, StringPattern[] stringPatterns) {
        this();
        this.columns = columns;
        this.dictionaries = dictionaries;
        this.stringPatterns = stringPatterns;
        this.synonymCatalogs = synonymCatalogs;
    }

    public ReferenceDataMatcherAnalyzer() {
    }

    @Validate
    public void validate() {
        if (!(this.isDictionaryMatchingEnabled() || this.isSynonymCatalogLookupEnabled() || this.isStringPatternMatchingEnabled())) {
            throw new IllegalStateException("No dictionaries, synonym catalogs or string patterns selected");
        }
    }

    @Initialize
    public void init() {
        this._dictionaryMatchers = new DictionaryMatcherTransformer[this.columns.length];
        this._stringPatternMatchers = new StringPatternMatcherTransformer[this.columns.length];
        this._matchColumns = new ArrayList<InputColumn<Boolean>>();
        for (int i = 0; i < this.columns.length; ++i) {
            OutputColumns outputColumns;
            if (this.isDictionaryMatchingEnabled()) {
                DictionaryMatcherTransformer dictionaryMatcher = new DictionaryMatcherTransformer(this.columns[i], this.dictionaries);
                outputColumns = dictionaryMatcher.getOutputColumns();
                this.addMatchColumns(outputColumns);
                this._dictionaryMatchers[i] = dictionaryMatcher;
            }
            if (this.isSynonymCatalogLookupEnabled()) {
                outputColumns = new OutputColumns(this.synonymCatalogs.length);
                for (int j = 0; j < this.synonymCatalogs.length; ++j) {
                    SynonymCatalog synonymCatalog = this.synonymCatalogs[j];
                    outputColumns.setColumnType(j, Boolean.class);
                    outputColumns.setColumnName(j, this.columns[i].getName() + " in " + synonymCatalog.getName());
                }
                this.addMatchColumns(outputColumns);
            }
            if (!this.isStringPatternMatchingEnabled()) continue;
            StringPatternMatcherTransformer stringPatternMatcher = new StringPatternMatcherTransformer(this.columns[i], this.stringPatterns);
            outputColumns = stringPatternMatcher.getOutputColumns();
            this.addMatchColumns(outputColumns);
            this._stringPatternMatchers[i] = stringPatternMatcher;
        }
        InputColumn[] columnArray = this._matchColumns.toArray(new InputColumn[this._matchColumns.size()]);
        this._booleanAnalyzer = new BooleanAnalyzer(columnArray);
        this._booleanAnalyzer.init();
    }

    private boolean isStringPatternMatchingEnabled() {
        return this.stringPatterns != null && this.stringPatterns.length > 0;
    }

    private boolean isSynonymCatalogLookupEnabled() {
        return this.synonymCatalogs != null && this.synonymCatalogs.length > 0;
    }

    private boolean isDictionaryMatchingEnabled() {
        return this.dictionaries != null && this.dictionaries.length > 0;
    }

    private void addMatchColumns(OutputColumns outputColumns) {
        int count = outputColumns.getColumnCount();
        for (int i = 0; i < count; ++i) {
            String columnName = outputColumns.getColumnName(i);
            MockInputColumn col = new MockInputColumn(columnName, Boolean.class);
            this._matchColumns.add((InputColumn<Boolean>)col);
        }
    }

    public void run(InputRow row, int distinctCount) {
        MockInputRow mockInputRow = new MockInputRow();
        int matchColumnIndex = 0;
        for (int i = 0; i < this.columns.length; ++i) {
            InputColumn<Boolean> matchColumn;
            Object[] matches;
            Object value = row.getValue(this.columns[i]);
            String stringValue = ConvertToStringTransformer.transformValue((Object)value);
            mockInputRow.put(this.columns[i], value);
            if (this.isDictionaryMatchingEnabled()) {
                for (Object match : matches = this._dictionaryMatchers[i].transform(row)) {
                    assert (match instanceof Boolean);
                    matchColumn = this._matchColumns.get(matchColumnIndex);
                    ++matchColumnIndex;
                    mockInputRow.put(matchColumn, match);
                }
            }
            if (this.isSynonymCatalogLookupEnabled()) {
                for (SynonymCatalog synonymCatalog : this.synonymCatalogs) {
                    InputColumn<Boolean> matchColumn2 = this._matchColumns.get(matchColumnIndex);
                    ++matchColumnIndex;
                    String masterTerm = synonymCatalog.getMasterTerm(stringValue);
                    if (masterTerm == null) {
                        mockInputRow.put(matchColumn2, (Object)Boolean.FALSE);
                        continue;
                    }
                    mockInputRow.put(matchColumn2, (Object)Boolean.TRUE);
                }
            }
            if (!this.isStringPatternMatchingEnabled()) continue;
            for (Object match : matches = this._stringPatternMatchers[i].transform(row)) {
                assert (match instanceof Boolean);
                matchColumn = this._matchColumns.get(matchColumnIndex);
                ++matchColumnIndex;
                mockInputRow.put(matchColumn, match);
            }
        }
        this._booleanAnalyzer.run((InputRow)mockInputRow, distinctCount);
    }

    public BooleanAnalyzerResult getResult() {
        return this._booleanAnalyzer.getResult();
    }
}

