/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.analyzer.beans.filter;

import org.eobjects.analyzer.beans.api.Alias;
import org.eobjects.analyzer.beans.api.Categorized;
import org.eobjects.analyzer.beans.api.Configured;
import org.eobjects.analyzer.beans.api.Description;
import org.eobjects.analyzer.beans.api.Filter;
import org.eobjects.analyzer.beans.api.FilterBean;
import org.eobjects.analyzer.beans.categories.FilterCategory;
import org.eobjects.analyzer.data.InputColumn;
import org.eobjects.analyzer.data.InputRow;
import org.eobjects.analyzer.reference.Dictionary;

@FilterBean(value="Validate in dictionary")
@Alias(value={"Dictionary lookup"})
@Description(value="Filters values based on their existence in a dictionary")
@Categorized(value={FilterCategory.class})
public class DictionaryFilter
implements Filter<Category> {
    @Configured
    InputColumn<String> column;
    @Configured
    Dictionary dictionary;

    public DictionaryFilter() {
    }

    public DictionaryFilter(InputColumn<String> column, Dictionary dictionary) {
        this();
        this.column = column;
        this.dictionary = dictionary;
    }

    public Category categorize(InputRow inputRow) {
        String value = (String)inputRow.getValue(this.column);
        if (value != null && this.dictionary.containsValue(value)) {
            return Category.VALID;
        }
        return Category.INVALID;
    }

    public static enum Category {
        VALID,
        INVALID;

    }
}

