/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.analyzer.beans.transform;

import java.util.StringTokenizer;
import org.eobjects.analyzer.beans.api.Alias;
import org.eobjects.analyzer.beans.api.Configured;
import org.eobjects.analyzer.beans.api.Description;
import org.eobjects.analyzer.beans.api.OutputColumns;
import org.eobjects.analyzer.beans.api.Transformer;
import org.eobjects.analyzer.beans.api.TransformerBean;
import org.eobjects.analyzer.data.InputColumn;
import org.eobjects.analyzer.data.InputRow;
import org.eobjects.analyzer.reference.SynonymCatalog;

@TransformerBean(value="Synonym lookup")
@Alias(value={"Synonym replacement"})
@Description(value="Replaces strings with their synonyms")
public class SynonymLookupTransformer
implements Transformer<String> {
    @Configured
    InputColumn<String> column;
    @Configured
    SynonymCatalog synonymCatalog;
    @Configured
    @Description(value="Retain original value in case no synonym is found (otherwise null)")
    boolean retainOriginalValue = true;
    @Configured
    @Description(value="Tokenize and look up every token of the input, rather than looking up the complete input string?")
    boolean lookUpEveryToken = false;

    public SynonymLookupTransformer() {
    }

    public SynonymLookupTransformer(InputColumn<String> column, SynonymCatalog synonymCatalog, boolean retainOriginalValue) {
        this();
        this.column = column;
        this.synonymCatalog = synonymCatalog;
        this.retainOriginalValue = retainOriginalValue;
    }

    public OutputColumns getOutputColumns() {
        return new OutputColumns(new String[]{this.column.getName() + " (synonyms replaced)"});
    }

    public String[] transform(InputRow inputRow) {
        String originalValue = (String)inputRow.getValue(this.column);
        if (originalValue == null) {
            return new String[1];
        }
        if (this.lookUpEveryToken) {
            String delim = " \t\n\r\f.,!?\"'+-_:;/\\\\()%@";
            StringBuilder sb = new StringBuilder();
            StringTokenizer tokenizer = new StringTokenizer(originalValue, " \t\n\r\f.,!?\"'+-_:;/\\\\()%@", true);
            int numTokens = tokenizer.countTokens();
            for (int i = 0; i < numTokens; ++i) {
                String token = tokenizer.nextToken();
                if (token.matches(" \t\n\r\f.,!?\"'+-_:;/\\\\()%@")) {
                    sb.append(token);
                    continue;
                }
                String replacedToken = this.lookup(token);
                if (replacedToken == null) {
                    sb.append(token);
                    continue;
                }
                sb.append(replacedToken);
            }
            return new String[]{sb.toString()};
        }
        String replacedValue = this.lookup(originalValue);
        return new String[]{replacedValue};
    }

    private String lookup(String originalValue) {
        String replacedValue = this.synonymCatalog.getMasterTerm(originalValue);
        if (this.retainOriginalValue && replacedValue == null) {
            return originalValue;
        }
        return replacedValue;
    }
}

