/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.analyzer.beans.standardize;

import javax.inject.Inject;
import org.eobjects.analyzer.beans.api.Categorized;
import org.eobjects.analyzer.beans.api.Configured;
import org.eobjects.analyzer.beans.api.Description;
import org.eobjects.analyzer.beans.api.OutputColumns;
import org.eobjects.analyzer.beans.api.Transformer;
import org.eobjects.analyzer.beans.api.TransformerBean;
import org.eobjects.analyzer.beans.categories.MatchingAndStandardizationCategory;
import org.eobjects.analyzer.data.InputColumn;
import org.eobjects.analyzer.data.InputRow;
import org.eobjects.analyzer.util.HasGroupLiteral;
import org.eobjects.analyzer.util.NamedPattern;
import org.eobjects.analyzer.util.NamedPatternMatch;

@TransformerBean(value="Email standardizer")
@Description(value="Retrieve the username or domain from an email address.")
@Categorized(value={MatchingAndStandardizationCategory.class})
public class EmailStandardizerTransformer
implements Transformer<String> {
    public static final NamedPattern<EmailPart> EMAIL_PATTERN = new NamedPattern<EmailPart>("USERNAME@DOMAIN", EmailPart.class);
    @Inject
    @Configured
    InputColumn<String> inputColumn;

    public OutputColumns getOutputColumns() {
        return new OutputColumns("Username", new String[]{"Domain"});
    }

    public String[] transform(InputRow inputRow) {
        String value = (String)inputRow.getValue(this.inputColumn);
        return this.transform(value);
    }

    public String[] transform(String value) {
        NamedPatternMatch<EmailPart> match;
        String username = null;
        String domain = null;
        if (value != null && (match = EMAIL_PATTERN.match(value)) != null) {
            username = match.get(EmailPart.USERNAME);
            domain = match.get(EmailPart.DOMAIN);
        }
        return new String[]{username, domain};
    }

    public void setInputColumn(InputColumn<String> inputColumn) {
        this.inputColumn = inputColumn;
    }

    public static enum EmailPart implements HasGroupLiteral
    {
        USERNAME("([a-zA-Z0-9\\._%+-]+)"),
        DOMAIN("([a-zA-Z0-9\\._%+-]+\\.[a-zA-Z0-9\\._%+-]{2,4})");

        private String groupLiteral;

        private EmailPart(String groupLiteral) {
            this.groupLiteral = groupLiteral;
        }

        @Override
        public String getGroupLiteral() {
            return this.groupLiteral;
        }
    }
}

