/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.analyzer.beans.standardize;

import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import org.eobjects.analyzer.beans.api.Categorized;
import org.eobjects.analyzer.beans.api.Configured;
import org.eobjects.analyzer.beans.api.Description;
import org.eobjects.analyzer.beans.api.Initialize;
import org.eobjects.analyzer.beans.api.OutputColumns;
import org.eobjects.analyzer.beans.api.Transformer;
import org.eobjects.analyzer.beans.api.TransformerBean;
import org.eobjects.analyzer.beans.categories.MatchingAndStandardizationCategory;
import org.eobjects.analyzer.data.InputColumn;
import org.eobjects.analyzer.data.InputRow;
import org.eobjects.analyzer.util.HasGroupLiteral;
import org.eobjects.analyzer.util.NamedPattern;
import org.eobjects.analyzer.util.NamedPatternMatch;

@TransformerBean(value="Name standardizer")
@Description(value="Identify the various parts of a full name column and turn it into separate, standardized tokens.")
@Categorized(value={MatchingAndStandardizationCategory.class})
public class NameStandardizerTransformer
implements Transformer<String> {
    public static final String[] DEFAULT_PATTERNS = new String[]{"FIRSTNAME LASTNAME", "TITULATION. FIRSTNAME LASTNAME", "TITULATION FIRSTNAME LASTNAME", "FIRSTNAME MIDDLENAME LASTNAME", "TITULATION. FIRSTNAME MIDDLENAME LASTNAME", "LASTNAME, FIRSTNAME", "LASTNAME, FIRSTNAME MIDDLENAME"};
    @Inject
    @Configured
    InputColumn<String> inputColumn;
    @Inject
    @Configured(value="Name patterns")
    String[] stringPatterns = DEFAULT_PATTERNS;
    private List<NamedPattern<NamePart>> namedPatterns;

    @Initialize
    public void init() {
        if (this.stringPatterns == null) {
            this.stringPatterns = new String[0];
        }
        this.namedPatterns = new ArrayList<NamedPattern<NamePart>>();
        for (String stringPattern : this.stringPatterns) {
            this.namedPatterns.add(new NamedPattern<NamePart>(stringPattern, NamePart.class));
        }
    }

    public OutputColumns getOutputColumns() {
        return new OutputColumns("Firstname", new String[]{"Lastname", "Middlename", "Titulation"});
    }

    public String[] transform(InputRow inputRow) {
        String value = (String)inputRow.getValue(this.inputColumn);
        return this.transform(value);
    }

    public String[] transform(String value) {
        String firstName = null;
        String lastName = null;
        String middleName = null;
        String titulation = null;
        if (value != null) {
            for (NamedPattern<NamePart> namedPattern : this.namedPatterns) {
                NamedPatternMatch<NamePart> match = namedPattern.match(value);
                if (match == null) continue;
                firstName = match.get(NamePart.FIRSTNAME);
                lastName = match.get(NamePart.LASTNAME);
                middleName = match.get(NamePart.MIDDLENAME);
                titulation = match.get(NamePart.TITULATION);
                break;
            }
        }
        return new String[]{firstName, lastName, middleName, titulation};
    }

    public void setInputColumn(InputColumn<?> inputColumn) {
        this.inputColumn = inputColumn;
    }

    public void setStringPatterns(String ... stringPatterns) {
        this.stringPatterns = stringPatterns;
    }

    public static enum NamePart implements HasGroupLiteral
    {
        FIRSTNAME,
        LASTNAME,
        MIDDLENAME,
        TITULATION;


        @Override
        public String getGroupLiteral() {
            if (this == TITULATION) {
                return "(Mr|Ms|Mrs|Hr|Fru|Frk|Miss|Mister)";
            }
            return null;
        }
    }
}

