/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.analyzer.util;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eobjects.analyzer.util.HasGroupLiteral;
import org.eobjects.analyzer.util.NamedPatternMatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NamedPattern<E extends Enum<E>> {
    private static final Logger logger = LoggerFactory.getLogger(NamedPattern.class);
    public static final String DEFAULT_GROUP_LITERAL = "([\\p{Lu}\\p{Ll}]+)";
    private EnumMap<E, Integer> groupIndexes;
    private Pattern pattern;
    private Class<E> groupEnum;

    public NamedPattern(String pattern, Class<E> groupEnum) {
        Enum group;
        if (pattern == null) {
            throw new IllegalArgumentException("pattern cannot be null");
        }
        if (groupEnum == null) {
            throw new IllegalArgumentException("groupEnum cannot be null");
        }
        pattern = pattern.replaceAll("\\(", "\\\\(");
        pattern = pattern.replaceAll("\\)", "\\\\)");
        pattern = pattern.replaceAll("\\[", "\\\\[");
        pattern = pattern.replaceAll("\\]", "\\\\]");
        this.groupEnum = groupEnum;
        this.groupIndexes = new EnumMap(groupEnum);
        Enum[] availableGroupNames = (Enum[])groupEnum.getEnumConstants();
        ArrayList<Enum> usedGroupNames = new ArrayList<Enum>();
        ArrayList<Integer> groupNameStringIndexOfs = new ArrayList<Integer>();
        for (int i = 0; i < availableGroupNames.length; ++i) {
            group = availableGroupNames[i];
            String groupToken = this.getGroupToken(group);
            int indexOf = pattern.indexOf(groupToken);
            if (indexOf == -1) continue;
            usedGroupNames.add(group);
            groupNameStringIndexOfs.add(indexOf);
        }
        if (usedGroupNames.isEmpty()) {
            throw new IllegalArgumentException("None of the groups defined in " + groupEnum.getSimpleName() + " where found in the pattern: " + pattern);
        }
        Integer groupIndex = this.getIndexOfHighest(groupNameStringIndexOfs);
        while (groupIndex != null) {
            group = (Enum)usedGroupNames.remove(groupIndex);
            groupNameStringIndexOfs.remove(groupIndex);
            this.groupIndexes.put(group, usedGroupNames.size() + 1);
            pattern = pattern.replace(this.getGroupToken(group), this.getGroupLiteral(group));
            groupIndex = this.getIndexOfHighest(groupNameStringIndexOfs);
        }
        logger.info("compiling pattern: {}", (Object)pattern);
        this.pattern = Pattern.compile(pattern);
    }

    protected String getGroupToken(E group) {
        return ((Enum)group).name();
    }

    protected String getGroupLiteral(E group) {
        if (group instanceof HasGroupLiteral) {
            String groupLiteral = ((HasGroupLiteral)group).getGroupLiteral();
            if (groupLiteral == null) {
                return DEFAULT_GROUP_LITERAL;
            }
            return groupLiteral;
        }
        return DEFAULT_GROUP_LITERAL;
    }

    private Integer getIndexOfHighest(List<Integer> integerList) {
        Integer result = null;
        int highestValue = -1;
        for (int i = 0; i < integerList.size(); ++i) {
            Integer integer = integerList.get(i);
            if (integer <= highestValue) continue;
            result = i;
            highestValue = integer;
        }
        return result;
    }

    public NamedPatternMatch<E> match(String string) {
        Matcher matcher = this.pattern.matcher(string);
        while (matcher.find()) {
            int start = matcher.start();
            int end = matcher.end();
            if (start != 0 || end != string.length()) continue;
            EnumMap<E, String> resultMap = new EnumMap<E, String>(this.groupEnum);
            Set<Map.Entry<E, Integer>> entries = this.groupIndexes.entrySet();
            for (Map.Entry<E, Integer> entry : entries) {
                Enum group = (Enum)entry.getKey();
                Integer groupIndex = entry.getValue();
                String result = matcher.group(groupIndex);
                resultMap.put(group, result);
            }
            return new NamedPatternMatch<E>(resultMap);
        }
        return null;
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public Set<E> getUsedGroups() {
        return this.groupIndexes.keySet();
    }
}

