/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.analyzer.beans.valuedist;

import java.util.Collection;
import org.eobjects.analyzer.beans.valuedist.ValueDistributionAnalyzerResult;
import org.eobjects.analyzer.data.InputColumn;
import org.eobjects.analyzer.result.AnnotatedRowsResult;
import org.eobjects.analyzer.result.GroupedValueCountingAnalyzerResult;
import org.eobjects.analyzer.result.ValueCountingAnalyzerResult;
import org.eobjects.analyzer.result.ValueFrequency;

public class GroupedValueDistributionResult
extends ValueDistributionAnalyzerResult
implements GroupedValueCountingAnalyzerResult {
    private static final long serialVersionUID = 1L;
    private final InputColumn<?> _column;
    private final InputColumn<String> _groupColumn;
    private final Collection<? extends ValueCountingAnalyzerResult> _result;

    public GroupedValueDistributionResult(InputColumn<?> column, InputColumn<String> groupColumn, Collection<? extends ValueCountingAnalyzerResult> groupedResult) {
        this._column = column;
        this._groupColumn = groupColumn;
        this._result = groupedResult;
    }

    @Override
    public String getGroupDiscriminatorName() {
        if (this._groupColumn == null) {
            return null;
        }
        return this._groupColumn.getName();
    }

    @Override
    public Integer getDistinctCount() {
        return this.getSingleValueDistributionResult().getDistinctCount();
    }

    @Override
    public int getNullCount() {
        return this.getSingleValueDistributionResult().getNullCount();
    }

    @Override
    public int getTotalCount() {
        return this.getSingleValueDistributionResult().getTotalCount();
    }

    @Override
    public Integer getCount(String value) {
        return this.getSingleValueDistributionResult().getCount(value);
    }

    @Override
    public Integer getUniqueCount() {
        return this.getSingleValueDistributionResult().getUniqueCount();
    }

    @Override
    public Collection<ValueFrequency> getValueCounts() {
        return this.getSingleValueDistributionResult().getValueCounts();
    }

    @Override
    public Collection<? extends ValueCountingAnalyzerResult> getGroupResults() {
        return this._result;
    }

    public ValueCountingAnalyzerResult getSingleValueDistributionResult() {
        return this._result.iterator().next();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Value distribution for column: ");
        sb.append(this._column.getName());
        for (ValueCountingAnalyzerResult valueCountingAnalyzerResult : this.getGroupResults()) {
            if (this.getGroupDiscriminatorName() != null) {
                sb.append("\n");
                sb.append("\nGroup: ");
            }
            sb.append(valueCountingAnalyzerResult.getName());
            this.appendToString(sb, valueCountingAnalyzerResult, 4);
        }
        return sb.toString();
    }

    @Override
    public String getName() {
        return this._column.getName();
    }

    @Override
    public AnnotatedRowsResult getAnnotatedRowsForValue(String value) {
        return this.getSingleValueDistributionResult().getAnnotatedRowsForValue(value);
    }

    @Override
    public AnnotatedRowsResult getAnnotatedRowsForNull() {
        return this.getSingleValueDistributionResult().getAnnotatedRowsForNull();
    }

    @Override
    public AnnotatedRowsResult getAnnotatedRowsForUnexpectedValues() {
        return null;
    }

    @Override
    public Collection<String> getUniqueValues() {
        return this.getSingleValueDistributionResult().getUniqueValues();
    }

    @Override
    public boolean hasAnnotatedRows(String value) {
        return this.getSingleValueDistributionResult().hasAnnotatedRows(value);
    }

    @Override
    public Integer getUnexpectedValueCount() {
        return null;
    }
}

