/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.analyzer.beans.valuedist;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.eobjects.analyzer.beans.api.Analyzer;
import org.eobjects.analyzer.beans.api.AnalyzerBean;
import org.eobjects.analyzer.beans.api.Categorized;
import org.eobjects.analyzer.beans.api.Concurrent;
import org.eobjects.analyzer.beans.api.Configured;
import org.eobjects.analyzer.beans.api.Description;
import org.eobjects.analyzer.beans.api.Distributed;
import org.eobjects.analyzer.beans.api.Initialize;
import org.eobjects.analyzer.beans.categories.DateAndTimeCategory;
import org.eobjects.analyzer.beans.valuedist.MonthDistributionResultReducer;
import org.eobjects.analyzer.data.InputColumn;
import org.eobjects.analyzer.data.InputRow;
import org.eobjects.analyzer.result.Crosstab;
import org.eobjects.analyzer.result.CrosstabDimension;
import org.eobjects.analyzer.result.CrosstabNavigator;
import org.eobjects.analyzer.result.CrosstabResult;
import org.eobjects.metamodel.util.Month;

@AnalyzerBean(value="Month distribution")
@Description(value="Finds the distribution of months from Date values.")
@Concurrent(value=true)
@Categorized(value={DateAndTimeCategory.class})
@Distributed(reducer=MonthDistributionResultReducer.class)
public class MonthDistributionAnalyzer
implements Analyzer<CrosstabResult> {
    private final Map<InputColumn<Date>, ConcurrentMap<Integer, AtomicInteger>> distributionMap = new HashMap<InputColumn<Date>, ConcurrentMap<Integer, AtomicInteger>>();
    @Configured
    InputColumn<Date>[] dateColumns;

    @Initialize
    public void init() {
        for (InputColumn<Date> col : this.dateColumns) {
            ConcurrentHashMap countMap = new ConcurrentHashMap();
            this.distributionMap.put(col, countMap);
        }
    }

    public void run(InputRow row, int distinctCount) {
        for (InputColumn<Date> col : this.dateColumns) {
            Date value = (Date)row.getValue(col);
            if (value == null) continue;
            Calendar c = Calendar.getInstance();
            c.setTime(value);
            int monthConstant = c.get(2);
            ConcurrentMap<Integer, AtomicInteger> countMap = this.distributionMap.get(col);
            AtomicInteger previousCount = countMap.putIfAbsent(monthConstant, new AtomicInteger(distinctCount));
            if (previousCount == null) continue;
            previousCount.addAndGet(distinctCount);
        }
    }

    public CrosstabResult getResult() {
        CrosstabDimension columnDimension = new CrosstabDimension("Column");
        CrosstabDimension monthDimension = new CrosstabDimension("Month");
        for (Month month : Month.values()) {
            String monthName = this.toMonthName(month);
            monthDimension.addCategory(monthName);
        }
        Crosstab crosstab = new Crosstab(Integer.class, new CrosstabDimension[]{columnDimension, monthDimension});
        for (InputColumn<Date> col : this.dateColumns) {
            columnDimension.addCategory(col.getName());
            CrosstabNavigator nav = crosstab.where(columnDimension, col.getName());
            Map countMap = this.distributionMap.get(col);
            for (Map.Entry entry : countMap.entrySet()) {
                Integer monthConstant = (Integer)entry.getKey();
                Month month = Month.getByCalendarConstant((int)monthConstant);
                AtomicInteger count = (AtomicInteger)entry.getValue();
                String monthName = this.toMonthName(month);
                nav.where(monthDimension, monthName).put((Serializable)Integer.valueOf(count.intValue()));
            }
        }
        return new CrosstabResult(crosstab);
    }

    private String toMonthName(Month month) {
        String upperCaseMonthName = month.toString();
        String monthName = upperCaseMonthName.charAt(0) + upperCaseMonthName.substring(1).toLowerCase();
        return monthName;
    }

    public void setDateColumns(InputColumn<Date>[] dateColumns) {
        this.dateColumns = dateColumns;
    }
}

