/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.analyzer.beans.valuedist;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.eobjects.analyzer.beans.valuedist.ValueDistributionAnalyzerResult;
import org.eobjects.analyzer.data.InputColumn;
import org.eobjects.analyzer.result.AnnotatedRowsResult;
import org.eobjects.analyzer.result.CompositeValueFrequency;
import org.eobjects.analyzer.result.SingleValueFrequency;
import org.eobjects.analyzer.result.ValueCountList;
import org.eobjects.analyzer.result.ValueCountListImpl;
import org.eobjects.analyzer.result.ValueFrequency;
import org.eobjects.analyzer.storage.RowAnnotation;
import org.eobjects.analyzer.storage.RowAnnotationFactory;
import org.eobjects.analyzer.util.NullTolerableComparator;
import org.eobjects.metamodel.util.Ref;
import org.eobjects.metamodel.util.SerializableRef;

public class SingleValueDistributionResult
extends ValueDistributionAnalyzerResult
implements Comparable<SingleValueDistributionResult> {
    private static final long serialVersionUID = 1L;
    private final ValueCountList _topValues;
    private final ValueCountList _bottomValues;
    private final Collection<String> _uniqueValues;
    private final Map<String, RowAnnotation> _annotations;
    private final RowAnnotation _nullValueAnnotation;
    private final InputColumn<?>[] _highlightedColumns;
    private final int _uniqueValueCount;
    private final String _groupName;
    private final int _nullCount;
    private final int _totalCount;
    private final int _distinctCount;
    private final Ref<RowAnnotationFactory> _annotationFactoryRef;

    public SingleValueDistributionResult(String groupName, ValueCountList topValues, ValueCountList bottomValues, Collection<String> uniqueValues, int uniqueValueCount, int distinctCount, int totalCount, Map<String, RowAnnotation> annotations, RowAnnotation nullValueAnnotation, RowAnnotationFactory annotationFactory, InputColumn<?>[] highlightedColumns) {
        this._groupName = groupName;
        this._topValues = topValues;
        this._bottomValues = bottomValues;
        this._uniqueValues = uniqueValues;
        this._uniqueValueCount = uniqueValueCount;
        this._totalCount = totalCount;
        this._distinctCount = distinctCount;
        this._nullValueAnnotation = nullValueAnnotation;
        this._annotations = annotations;
        this._annotationFactoryRef = new SerializableRef((Object)annotationFactory);
        this._highlightedColumns = highlightedColumns;
        this._nullCount = 0;
    }

    public SingleValueDistributionResult(String groupName, ValueCountList topValues, ValueCountList bottomValues, int uniqueValueCount, int distinctCount, int totalCount, Map<String, RowAnnotation> annotations, RowAnnotation nullValueAnnotation, RowAnnotationFactory annotationFactory, InputColumn<?>[] highlightedColumns) {
        this(groupName, topValues, bottomValues, null, uniqueValueCount, distinctCount, totalCount, annotations, nullValueAnnotation, annotationFactory, highlightedColumns);
    }

    @Override
    public boolean hasAnnotatedRows(String value) {
        if (this._annotations == null) {
            return false;
        }
        RowAnnotationFactory annotationFactory = (RowAnnotationFactory)this._annotationFactoryRef.get();
        if (annotationFactory == null) {
            return false;
        }
        if (value == null) {
            return this._nullValueAnnotation != null;
        }
        return this._annotations.containsKey(value);
    }

    @Override
    public AnnotatedRowsResult getAnnotatedRowsForValue(String value) {
        if (this._annotations == null) {
            return null;
        }
        RowAnnotationFactory annotationFactory = (RowAnnotationFactory)this._annotationFactoryRef.get();
        if (annotationFactory == null) {
            return null;
        }
        RowAnnotation annotation = value == null ? this._nullValueAnnotation : this._annotations.get(value);
        if (annotation == null) {
            return null;
        }
        return new AnnotatedRowsResult(annotation, annotationFactory, this._highlightedColumns);
    }

    @Override
    public AnnotatedRowsResult getAnnotatedRowsForNull() {
        if (this._nullValueAnnotation == null) {
            return null;
        }
        RowAnnotationFactory annotationFactory = (RowAnnotationFactory)this._annotationFactoryRef.get();
        if (annotationFactory == null) {
            return null;
        }
        return new AnnotatedRowsResult(this._nullValueAnnotation, annotationFactory, this._highlightedColumns);
    }

    public ValueCountList getTopValues() {
        if (this._topValues == null) {
            return ValueCountListImpl.emptyList();
        }
        return this._topValues;
    }

    public ValueCountList getBottomValues() {
        if (this._bottomValues == null) {
            return ValueCountListImpl.emptyList();
        }
        return this._bottomValues;
    }

    @Override
    public int getNullCount() {
        if (this._nullValueAnnotation == null) {
            return this._nullCount;
        }
        return this._nullValueAnnotation.getRowCount();
    }

    public boolean isUniqueValuesAvailable() {
        return this._uniqueValues != null;
    }

    @Override
    public Integer getUniqueCount() {
        if (this._uniqueValues == null) {
            return this._uniqueValueCount;
        }
        return this._uniqueValues.size();
    }

    @Override
    public Collection<String> getUniqueValues() {
        if (this._uniqueValues == null) {
            return Collections.emptyList();
        }
        return this._uniqueValues;
    }

    @Override
    public String getName() {
        return this._groupName;
    }

    @Override
    public Integer getCount(String value) {
        List<ValueFrequency> valueCounts;
        if (value == null) {
            return this.getNullCount();
        }
        if (this._topValues != null) {
            valueCounts = this._topValues.getValueCounts();
            for (ValueFrequency valueCount : valueCounts) {
                if (!value.equals(valueCount.getValue())) continue;
                return valueCount.getCount();
            }
        }
        if (this._bottomValues != null) {
            valueCounts = this._bottomValues.getValueCounts();
            for (ValueFrequency valueCount : valueCounts) {
                if (!value.equals(valueCount.getValue())) continue;
                return valueCount.getCount();
            }
        }
        if (this._uniqueValues != null && this._uniqueValues.contains(value)) {
            return 1;
        }
        return null;
    }

    @Override
    public Integer getDistinctCount() {
        return this._distinctCount;
    }

    @Override
    public int getTotalCount() {
        return this._totalCount;
    }

    public int hashCode() {
        if (this._groupName == null) {
            return -1;
        }
        return this._groupName.hashCode();
    }

    @Override
    public Collection<ValueFrequency> getValueCounts() {
        int nullCount;
        TreeSet<ValueFrequency> result = new TreeSet<ValueFrequency>();
        if (this._topValues != null) {
            result.addAll(this._topValues.getValueCounts());
        }
        if (this._bottomValues != null) {
            result.addAll(this._bottomValues.getValueCounts());
        }
        if ((nullCount = this.getNullCount()) > 0) {
            result.add(new SingleValueFrequency(null, nullCount));
        }
        if (this._uniqueValues != null && !this._uniqueValues.isEmpty()) {
            result.add(new CompositeValueFrequency("<unique>", this._uniqueValues, 1));
        } else if (this._uniqueValueCount > 0) {
            result.add(new CompositeValueFrequency("<unique>", this._uniqueValueCount));
        }
        return result;
    }

    @Override
    public AnnotatedRowsResult getAnnotatedRowsForUnexpectedValues() {
        return null;
    }

    @Override
    public int compareTo(SingleValueDistributionResult o) {
        return NullTolerableComparator.get(String.class).compare(this.getName(), o.getName());
    }

    @Override
    public Integer getUnexpectedValueCount() {
        return null;
    }
}

