/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.analyzer.beans.valuedist;

import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.inject.Inject;
import org.eobjects.analyzer.beans.api.Analyzer;
import org.eobjects.analyzer.beans.api.AnalyzerBean;
import org.eobjects.analyzer.beans.api.ColumnProperty;
import org.eobjects.analyzer.beans.api.Concurrent;
import org.eobjects.analyzer.beans.api.Configured;
import org.eobjects.analyzer.beans.api.Description;
import org.eobjects.analyzer.beans.api.Provided;
import org.eobjects.analyzer.beans.valuedist.GroupedValueDistributionResult;
import org.eobjects.analyzer.beans.valuedist.SingleValueDistributionResult;
import org.eobjects.analyzer.beans.valuedist.ValueDistributionAnalyzerResult;
import org.eobjects.analyzer.beans.valuedist.ValueDistributionGroup;
import org.eobjects.analyzer.data.InputColumn;
import org.eobjects.analyzer.data.InputRow;
import org.eobjects.analyzer.storage.CollectionFactory;
import org.eobjects.analyzer.storage.CollectionFactoryImpl;
import org.eobjects.analyzer.storage.InMemoryRowAnnotationFactory;
import org.eobjects.analyzer.storage.InMemoryStorageProvider;
import org.eobjects.analyzer.storage.RowAnnotationFactory;
import org.eobjects.analyzer.storage.StorageProvider;
import org.eobjects.analyzer.util.NullTolerableComparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AnalyzerBean(value="Value distribution")
@Description(value="Gets the distributions of values that occur in a dataset.\nOften used as an initial way to see if a lot of repeated values are to be expected, if nulls occur and if a few un-repeated values add exceptions to the typical usage-pattern.")
@Concurrent(value=true)
public class ValueDistributionAnalyzer
implements Analyzer<ValueDistributionAnalyzerResult> {
    private static final Logger logger = LoggerFactory.getLogger(ValueDistributionAnalyzer.class);
    @Inject
    @Configured(value="Column", order=1)
    @ColumnProperty(escalateToMultipleJobs=true)
    InputColumn<?> _column;
    @Inject
    @Configured(value="Group column", required=false, order=2)
    InputColumn<String> _groupColumn;
    @Inject
    @Configured(value="Record unique values", required=false, order=3)
    boolean _recordUniqueValues = true;
    @Inject
    @Configured(value="Record drill-down information", required=false, order=4)
    @Description(value="Record extra information to allow drilling to the records that represent a particular value in the distribution")
    boolean _recordDrillDownInformation = true;
    @Inject
    @Configured(value="Top n most frequent values", required=false, order=5)
    @Deprecated
    Integer _topFrequentValues;
    @Inject
    @Configured(value="Bottom n most frequent values", required=false, order=6)
    @Deprecated
    Integer _bottomFrequentValues;
    @Inject
    @Provided
    CollectionFactory _collectionFactory;
    @Inject
    @Provided
    RowAnnotationFactory _annotationFactory;
    private final Map<String, ValueDistributionGroup> _valueDistributionGroups = new TreeMap<String, ValueDistributionGroup>(NullTolerableComparator.get(String.class));

    public ValueDistributionAnalyzer(InputColumn<?> column, boolean recordUniqueValues, Integer topFrequentValues, Integer bottomFrequentValues) {
        this(column, null, recordUniqueValues, topFrequentValues, bottomFrequentValues);
    }

    public ValueDistributionAnalyzer(InputColumn<?> column, InputColumn<String> groupColumn, boolean recordUniqueValues, Integer topFrequentValues, Integer bottomFrequentValues) {
        this();
        this._column = column;
        this._groupColumn = groupColumn;
        this._recordUniqueValues = recordUniqueValues;
        this._topFrequentValues = topFrequentValues;
        this._bottomFrequentValues = bottomFrequentValues;
        this._collectionFactory = new CollectionFactoryImpl((StorageProvider)new InMemoryStorageProvider());
        this._annotationFactory = new InMemoryRowAnnotationFactory();
    }

    public ValueDistributionAnalyzer() {
    }

    public void run(InputRow row, int distinctCount) {
        Object value = row.getValue(this._column);
        if (this._groupColumn == null) {
            this.runInternal(row, value, distinctCount);
        } else {
            String group = (String)row.getValue(this._groupColumn);
            this.runInternal(row, value, group, distinctCount);
        }
    }

    public void runInternal(InputRow row, Object value, int distinctCount) {
        this.runInternal(row, value, this._column.getName(), distinctCount);
    }

    public void runInternal(InputRow row, Object value, String group, int distinctCount) {
        String stringValue;
        ValueDistributionGroup valueDistributionGroup = this.getValueDistributionGroup(group);
        if (value == null) {
            logger.debug("value is null");
            stringValue = null;
        } else {
            stringValue = value.toString();
        }
        valueDistributionGroup.run(row, stringValue, distinctCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ValueDistributionGroup getValueDistributionGroup(String group) {
        ValueDistributionGroup valueDistributionGroup = this._valueDistributionGroups.get(group);
        if (valueDistributionGroup == null) {
            ValueDistributionAnalyzer valueDistributionAnalyzer = this;
            synchronized (valueDistributionAnalyzer) {
                valueDistributionGroup = this._valueDistributionGroups.get(group);
                if (valueDistributionGroup == null) {
                    InputColumn[] inputColumns = this._groupColumn == null ? new InputColumn[]{this._column} : new InputColumn[]{this._column, this._groupColumn};
                    valueDistributionGroup = new ValueDistributionGroup(group, this._collectionFactory, this._annotationFactory, this._recordDrillDownInformation, inputColumns);
                    this._valueDistributionGroups.put(group, valueDistributionGroup);
                }
            }
        }
        return valueDistributionGroup;
    }

    public ValueDistributionAnalyzerResult getResult() {
        if (this._groupColumn == null) {
            logger.info("getResult() invoked, processing single group");
            ValueDistributionGroup valueDistributionGroup = this.getValueDistributionGroup(this._column.getName());
            SingleValueDistributionResult ungroupedResult = valueDistributionGroup.createResult(this._topFrequentValues, this._bottomFrequentValues, this._recordUniqueValues);
            return ungroupedResult;
        }
        logger.info("getResult() invoked, processing {} groups", (Object)this._valueDistributionGroups.size());
        TreeSet<SingleValueDistributionResult> groupedResults = new TreeSet<SingleValueDistributionResult>();
        for (String group : this._valueDistributionGroups.keySet()) {
            ValueDistributionGroup valueDistributibutionGroup = this.getValueDistributionGroup(group);
            SingleValueDistributionResult result = valueDistributibutionGroup.createResult(this._topFrequentValues, this._bottomFrequentValues, this._recordUniqueValues);
            groupedResults.add(result);
        }
        return new GroupedValueDistributionResult(this._column, this._groupColumn, groupedResults);
    }

    public void setAnnotationFactory(RowAnnotationFactory annotationFactory) {
        this._annotationFactory = annotationFactory;
    }

    public void setCollectionFactory(CollectionFactory collectionFactory) {
        this._collectionFactory = collectionFactory;
    }

    @Deprecated
    public void setBottomFrequentValues(Integer bottomFrequentValues) {
        this._bottomFrequentValues = bottomFrequentValues;
    }

    public void setColumn(InputColumn<?> column) {
        this._column = column;
    }

    public void setGroupColumn(InputColumn<String> groupColumn) {
        this._groupColumn = groupColumn;
    }

    public void setRecordDrillDownInformation(boolean recordDrillDownInformation) {
        this._recordDrillDownInformation = recordDrillDownInformation;
    }

    public void setRecordUniqueValues(boolean recordUniqueValues) {
        this._recordUniqueValues = recordUniqueValues;
    }

    @Deprecated
    public void setTopFrequentValues(Integer topFrequentValues) {
        this._topFrequentValues = topFrequentValues;
    }
}

