/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.analyzer.beans.valuedist;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eobjects.analyzer.beans.valuedist.SingleValueDistributionResult;
import org.eobjects.analyzer.data.InputColumn;
import org.eobjects.analyzer.data.InputRow;
import org.eobjects.analyzer.result.SingleValueFrequency;
import org.eobjects.analyzer.result.ValueCountListImpl;
import org.eobjects.analyzer.storage.CollectionFactory;
import org.eobjects.analyzer.storage.RowAnnotation;
import org.eobjects.analyzer.storage.RowAnnotationFactory;
import org.eobjects.analyzer.storage.RowAnnotationImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ValueDistributionGroup {
    private static final Logger logger = LoggerFactory.getLogger(ValueDistributionGroup.class);
    private final Map<String, Integer> _counterMap;
    private final Map<String, RowAnnotation> _annotationMap;
    private final RowAnnotation _nullValueAnnotation;
    private final RowAnnotationFactory _annotationFactory;
    private final String _groupName;
    private final boolean _recordAnnotations;
    private final InputColumn<?>[] _inputColumns;
    private int _totalCount;

    public ValueDistributionGroup(String groupName, CollectionFactory collectionFactory, RowAnnotationFactory annotationFactory, boolean recordAnnotations, InputColumn<?>[] inputColumns) {
        this._groupName = groupName;
        this._annotationFactory = annotationFactory;
        this._recordAnnotations = recordAnnotations;
        this._inputColumns = inputColumns;
        if (recordAnnotations) {
            this._annotationMap = new HashMap<String, RowAnnotation>();
            this._counterMap = null;
            this._nullValueAnnotation = this._annotationFactory.createAnnotation();
        } else {
            this._annotationMap = null;
            this._counterMap = collectionFactory.createMap(String.class, Integer.class);
            this._nullValueAnnotation = new RowAnnotationImpl();
        }
    }

    public synchronized void run(InputRow row, String value, int distinctCount) {
        if (value == null) {
            if (this._recordAnnotations) {
                this._annotationFactory.annotate(row, distinctCount, this._nullValueAnnotation);
            } else {
                ((RowAnnotationImpl)this._nullValueAnnotation).incrementRowCount(distinctCount);
            }
        } else if (this._recordAnnotations) {
            RowAnnotation annotation = this._annotationMap.get(value);
            if (annotation == null) {
                annotation = this._annotationFactory.createAnnotation();
                this._annotationMap.put(value, annotation);
            }
            this._annotationFactory.annotate(row, distinctCount, annotation);
        } else {
            Integer count = this._counterMap.get(value);
            if (count == null) {
                count = 0;
            }
            count = count + distinctCount;
            this._counterMap.put(value, count);
        }
        this._totalCount += distinctCount;
    }

    public SingleValueDistributionResult createResult(Integer topFrequentValues, Integer bottomFrequentValues, boolean recordUniqueValues) {
        int i;
        Set<Map.Entry<String, Object>> entrySet;
        int entryCount;
        ValueCountListImpl bottomValues;
        ValueCountListImpl topValues;
        if (topFrequentValues == null || bottomFrequentValues == null) {
            topValues = ValueCountListImpl.createFullList();
            bottomValues = null;
        } else {
            topValues = ValueCountListImpl.createTopList(topFrequentValues);
            bottomValues = ValueCountListImpl.createBottomList(bottomFrequentValues);
        }
        ArrayList<String> uniqueValues = recordUniqueValues ? new ArrayList<String>() : null;
        int uniqueCount = 0;
        if (this._recordAnnotations) {
            entryCount = this._annotationMap.size();
            entrySet = this._annotationMap.entrySet();
            i = 0;
            for (Map.Entry<String, Object> entry : entrySet) {
                if (i % 100000 == 0 && i != 0) {
                    logger.info("Processing unique value entry no. {}", (Object)i);
                }
                String value = entry.getKey();
                RowAnnotation annotation = (RowAnnotation)entry.getValue();
                int count = annotation.getRowCount();
                uniqueCount = this.countValue(recordUniqueValues, topValues, bottomValues, uniqueValues, uniqueCount, value, count);
                ++i;
            }
        } else {
            entryCount = this._counterMap.size();
            entrySet = this._counterMap.entrySet();
            i = 0;
            for (Map.Entry<String, Object> entry : entrySet) {
                if (i % 100000 == 0 && i != 0) {
                    logger.info("Processing unique value entry no. {}", (Object)i);
                }
                String value = entry.getKey();
                Integer count = (Integer)entry.getValue();
                uniqueCount = this.countValue(recordUniqueValues, topValues, bottomValues, uniqueValues, uniqueCount, value, count);
                ++i;
            }
        }
        int distinctCount = this._nullValueAnnotation.getRowCount() > 0 ? 1 + entryCount : entryCount;
        Map<String, RowAnnotation> annotations = this._recordAnnotations ? this._annotationMap : null;
        if (recordUniqueValues) {
            return new SingleValueDistributionResult(this._groupName, topValues, bottomValues, uniqueValues, uniqueCount, distinctCount, this._totalCount, annotations, this._nullValueAnnotation, this._annotationFactory, this._inputColumns);
        }
        return new SingleValueDistributionResult(this._groupName, topValues, bottomValues, uniqueCount, distinctCount, this._totalCount, annotations, this._nullValueAnnotation, this._annotationFactory, this._inputColumns);
    }

    private int countValue(boolean recordUniqueValues, ValueCountListImpl topValues, ValueCountListImpl bottomValues, List<String> uniqueValues, int uniqueCount, String value, int count) {
        if (count == 1) {
            if (recordUniqueValues) {
                uniqueValues.add(value);
            }
            ++uniqueCount;
        } else {
            SingleValueFrequency vc = new SingleValueFrequency(value, count);
            topValues.register(vc);
            if (bottomValues != null) {
                bottomValues.register(vc);
            }
        }
        return uniqueCount;
    }
}

