/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.analyzer.beans.valuedist;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.eobjects.analyzer.beans.api.Analyzer;
import org.eobjects.analyzer.beans.api.AnalyzerBean;
import org.eobjects.analyzer.beans.api.Categorized;
import org.eobjects.analyzer.beans.api.Concurrent;
import org.eobjects.analyzer.beans.api.Configured;
import org.eobjects.analyzer.beans.api.Description;
import org.eobjects.analyzer.beans.api.Distributed;
import org.eobjects.analyzer.beans.api.Initialize;
import org.eobjects.analyzer.beans.api.NumberProperty;
import org.eobjects.analyzer.beans.categories.DateAndTimeCategory;
import org.eobjects.analyzer.beans.valuedist.DatePartDistributionResultReducer;
import org.eobjects.analyzer.data.InputColumn;
import org.eobjects.analyzer.data.InputRow;
import org.eobjects.analyzer.result.Crosstab;
import org.eobjects.analyzer.result.CrosstabDimension;
import org.eobjects.analyzer.result.CrosstabNavigator;
import org.eobjects.analyzer.result.CrosstabResult;
import org.eobjects.metamodel.util.Weekday;

@AnalyzerBean(value="Week number distribution")
@Description(value="Finds the distribution of week numbers from Date values.")
@Concurrent(value=true)
@Categorized(value={DateAndTimeCategory.class})
@Distributed(reducer=DatePartDistributionResultReducer.class)
public class WeekNumberDistributionAnalyzer
implements Analyzer<CrosstabResult> {
    @Configured
    InputColumn<Date>[] dateColumns;
    @Configured(order=10)
    @NumberProperty(negative=false, positive=true)
    int minimalDaysInFirstWeek = Calendar.getInstance().getMinimalDaysInFirstWeek();
    @Configured(order=11)
    Weekday firstDayOfWeek = Weekday.getByCalendarConstant((int)Calendar.getInstance().getFirstDayOfWeek());
    private final Map<InputColumn<Date>, ConcurrentMap<Integer, AtomicInteger>> distributionMap = new HashMap<InputColumn<Date>, ConcurrentMap<Integer, AtomicInteger>>();

    @Initialize
    public void init() {
        for (InputColumn<Date> col : this.dateColumns) {
            ConcurrentHashMap countMap = new ConcurrentHashMap();
            this.distributionMap.put(col, countMap);
        }
    }

    public void run(InputRow row, int distinctCount) {
        for (InputColumn<Date> col : this.dateColumns) {
            Date value = (Date)row.getValue(col);
            if (value == null) continue;
            Calendar c = Calendar.getInstance();
            c.setMinimalDaysInFirstWeek(this.minimalDaysInFirstWeek);
            c.setFirstDayOfWeek(this.firstDayOfWeek.getCalendarConstant());
            c.setTime(value);
            int weekNumber = c.get(3);
            ConcurrentMap<Integer, AtomicInteger> countMap = this.distributionMap.get(col);
            AtomicInteger previousCount = countMap.putIfAbsent(weekNumber, new AtomicInteger(distinctCount));
            if (previousCount == null) continue;
            previousCount.addAndGet(distinctCount);
        }
    }

    public CrosstabResult getResult() {
        CrosstabDimension columnDimension = new CrosstabDimension("Column");
        CrosstabDimension weekNumberDimension = new CrosstabDimension("Week number");
        TreeSet weekNumbers = new TreeSet();
        for (InputColumn<Date> col : this.dateColumns) {
            Map countMap = this.distributionMap.get(col);
            Set weekNumbersOfColumn = countMap.keySet();
            weekNumbers.addAll(weekNumbersOfColumn);
        }
        for (Integer weekNumber : weekNumbers) {
            weekNumberDimension.addCategory(weekNumber + "");
        }
        Crosstab crosstab = new Crosstab(Integer.class, new CrosstabDimension[]{columnDimension, weekNumberDimension});
        for (InputColumn<Date> col : this.dateColumns) {
            columnDimension.addCategory(col.getName());
            CrosstabNavigator nav = crosstab.where(columnDimension, col.getName());
            Map countMap = this.distributionMap.get(col);
            for (Map.Entry entry : countMap.entrySet()) {
                Integer weekNumber = (Integer)entry.getKey();
                AtomicInteger count = (AtomicInteger)entry.getValue();
                nav.where(weekNumberDimension, weekNumber + "").put((Serializable)Integer.valueOf(count.intValue()));
            }
        }
        return new CrosstabResult(crosstab);
    }

    public void setDateColumns(InputColumn<Date>[] dateColumns) {
        this.dateColumns = dateColumns;
    }
}

