/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.analyzer.beans.valuedist;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.eobjects.analyzer.beans.api.Analyzer;
import org.eobjects.analyzer.beans.api.AnalyzerBean;
import org.eobjects.analyzer.beans.api.Categorized;
import org.eobjects.analyzer.beans.api.Concurrent;
import org.eobjects.analyzer.beans.api.Configured;
import org.eobjects.analyzer.beans.api.Description;
import org.eobjects.analyzer.beans.api.Distributed;
import org.eobjects.analyzer.beans.api.Initialize;
import org.eobjects.analyzer.beans.categories.DateAndTimeCategory;
import org.eobjects.analyzer.beans.valuedist.WeekdayDistributionResultReducer;
import org.eobjects.analyzer.data.InputColumn;
import org.eobjects.analyzer.data.InputRow;
import org.eobjects.analyzer.result.Crosstab;
import org.eobjects.analyzer.result.CrosstabDimension;
import org.eobjects.analyzer.result.CrosstabNavigator;
import org.eobjects.analyzer.result.CrosstabResult;

@AnalyzerBean(value="Weekday distribution")
@Description(value="Finds the distribution of weekdays from Date values.")
@Concurrent(value=true)
@Categorized(value={DateAndTimeCategory.class})
@Distributed(reducer=WeekdayDistributionResultReducer.class)
public class WeekdayDistributionAnalyzer
implements Analyzer<CrosstabResult> {
    private final Map<InputColumn<Date>, Map<Integer, AtomicInteger>> distributionMap = new HashMap<InputColumn<Date>, Map<Integer, AtomicInteger>>();
    @Configured
    InputColumn<Date>[] dateColumns;

    @Initialize
    public void init() {
        for (InputColumn<Date> col : this.dateColumns) {
            HashMap<Integer, AtomicInteger> countMap = new HashMap<Integer, AtomicInteger>(7);
            for (int i = 1; i <= 7; ++i) {
                countMap.put(i, new AtomicInteger(0));
            }
            this.distributionMap.put(col, countMap);
        }
    }

    public void run(InputRow row, int distinctCount) {
        for (InputColumn<Date> col : this.dateColumns) {
            Date value = (Date)row.getValue(col);
            if (value == null) continue;
            Calendar c = Calendar.getInstance();
            c.setTime(value);
            int dayOfWeek = c.get(7);
            Map<Integer, AtomicInteger> countMap = this.distributionMap.get(col);
            AtomicInteger count = countMap.get(dayOfWeek);
            count.addAndGet(distinctCount);
        }
    }

    public CrosstabResult getResult() {
        CrosstabDimension columnDimension = new CrosstabDimension("Column");
        CrosstabDimension weekdayDimension = new CrosstabDimension("Weekday");
        weekdayDimension.addCategory("Sunday").addCategory("Monday").addCategory("Tuesday").addCategory("Wednesday").addCategory("Thursday").addCategory("Friday").addCategory("Saturday");
        Crosstab crosstab = new Crosstab(Integer.class, new CrosstabDimension[]{columnDimension, weekdayDimension});
        for (InputColumn<Date> col : this.dateColumns) {
            columnDimension.addCategory(col.getName());
            CrosstabNavigator nav = crosstab.where(columnDimension, col.getName());
            Map<Integer, AtomicInteger> countMap = this.distributionMap.get(col);
            nav.where(weekdayDimension, "Sunday").put((Serializable)Integer.valueOf(countMap.get(1).get()));
            nav.where(weekdayDimension, "Monday").put((Serializable)Integer.valueOf(countMap.get(2).get()));
            nav.where(weekdayDimension, "Tuesday").put((Serializable)Integer.valueOf(countMap.get(3).get()));
            nav.where(weekdayDimension, "Wednesday").put((Serializable)Integer.valueOf(countMap.get(4).get()));
            nav.where(weekdayDimension, "Thursday").put((Serializable)Integer.valueOf(countMap.get(5).get()));
            nav.where(weekdayDimension, "Friday").put((Serializable)Integer.valueOf(countMap.get(6).get()));
            nav.where(weekdayDimension, "Saturday").put((Serializable)Integer.valueOf(countMap.get(7).get()));
        }
        return new CrosstabResult(crosstab);
    }

    public void setDateColumns(InputColumn<Date>[] dateColumns) {
        this.dateColumns = dateColumns;
    }
}

