/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.analyzer.beans.valuematch;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.inject.Inject;
import org.eobjects.analyzer.beans.api.Analyzer;
import org.eobjects.analyzer.beans.api.AnalyzerBean;
import org.eobjects.analyzer.beans.api.Concurrent;
import org.eobjects.analyzer.beans.api.Configured;
import org.eobjects.analyzer.beans.api.Description;
import org.eobjects.analyzer.beans.api.Initialize;
import org.eobjects.analyzer.beans.api.Provided;
import org.eobjects.analyzer.beans.valuematch.ValueMatchAnalyzerResult;
import org.eobjects.analyzer.data.InputColumn;
import org.eobjects.analyzer.data.InputRow;
import org.eobjects.analyzer.storage.RowAnnotation;
import org.eobjects.analyzer.storage.RowAnnotationFactory;
import org.eobjects.analyzer.util.StringUtils;

@AnalyzerBean(value="Value matcher")
@Description(value="Matches actual values against a set of expected values.\nUse this analyzer as a way to narrow down unexpected values, spelling mistakes, missing values and errors.")
@Concurrent(value=true)
public class ValueMatchAnalyzer
implements Analyzer<ValueMatchAnalyzerResult> {
    @Inject
    @Configured(order=10)
    InputColumn<?> column;
    @Inject
    @Configured(order=20)
    String[] expectedValues;
    @Inject
    @Configured(order=30)
    boolean caseSensitiveMatching = true;
    @Inject
    @Configured(order=31)
    boolean whiteSpaceSensitiveMatching = true;
    @Inject
    @Provided
    RowAnnotationFactory _rowAnnotationFactory;
    @Inject
    @Provided
    RowAnnotation _nullAnnotation;
    @Inject
    @Provided
    RowAnnotation _nonMatchingValuesAnnotation;
    private Map<String, RowAnnotation> _valueAnnotations;
    private AtomicInteger _totalCount;

    @Initialize
    public void init() {
        this._totalCount = new AtomicInteger();
        this._valueAnnotations = new ConcurrentHashMap<String, RowAnnotation>();
        for (String value : this.expectedValues) {
            RowAnnotation annotation = this._rowAnnotationFactory.createAnnotation();
            String lookupValue = this.getLookupValue(value);
            this._valueAnnotations.put(lookupValue, annotation);
        }
    }

    private String getLookupValue(String value) {
        if (!this.caseSensitiveMatching) {
            value = value.toLowerCase();
        }
        if (!this.whiteSpaceSensitiveMatching) {
            value = StringUtils.replaceWhitespaces((String)value, (String)"");
        }
        return value;
    }

    public void run(InputRow row, int distinctCount) {
        this._totalCount.addAndGet(distinctCount);
        Object value = row.getValue(this.column);
        if (value == null) {
            this._rowAnnotationFactory.annotate(row, distinctCount, this._nullAnnotation);
        } else {
            String stringValue = value.toString();
            String lookupValue = this.getLookupValue(stringValue);
            RowAnnotation annotation = this._valueAnnotations.get(lookupValue);
            if (annotation == null) {
                this._rowAnnotationFactory.annotate(row, distinctCount, this._nonMatchingValuesAnnotation);
            } else {
                this._rowAnnotationFactory.annotate(row, distinctCount, annotation);
            }
        }
    }

    public ValueMatchAnalyzerResult getResult() {
        LinkedHashMap<String, RowAnnotation> valueAnnotations = new LinkedHashMap<String, RowAnnotation>();
        for (String value : this.expectedValues) {
            String lookupValue = this.getLookupValue(value);
            RowAnnotation annotation = this._valueAnnotations.get(lookupValue);
            valueAnnotations.put(value, annotation);
        }
        return new ValueMatchAnalyzerResult(this.column, this._rowAnnotationFactory, valueAnnotations, this._nullAnnotation, this._nonMatchingValuesAnnotation, this._totalCount.get());
    }
}

