/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.analyzer.beans.valuematch;

import java.util.Collection;
import java.util.Map;
import java.util.TreeSet;
import org.eobjects.analyzer.beans.api.Distributed;
import org.eobjects.analyzer.beans.valuematch.ValueMatchAnalyzerResultReducer;
import org.eobjects.analyzer.data.InputColumn;
import org.eobjects.analyzer.result.AbstractValueCountingAnalyzerResult;
import org.eobjects.analyzer.result.AnnotatedRowsResult;
import org.eobjects.analyzer.result.CompositeValueFrequency;
import org.eobjects.analyzer.result.Metric;
import org.eobjects.analyzer.result.SingleValueFrequency;
import org.eobjects.analyzer.result.ValueFrequency;
import org.eobjects.analyzer.storage.RowAnnotation;
import org.eobjects.analyzer.storage.RowAnnotationFactory;
import org.eobjects.metamodel.util.SerializableRef;

@Distributed(reducer=ValueMatchAnalyzerResultReducer.class)
public class ValueMatchAnalyzerResult
extends AbstractValueCountingAnalyzerResult {
    private static final long serialVersionUID = 1L;
    private final InputColumn<?> _column;
    private final Map<String, RowAnnotation> _valueAnnotations;
    private final RowAnnotation _nullAnnotation;
    private final RowAnnotation _nonMatchingValuesAnnotation;
    private final int _totalCount;
    private final SerializableRef<RowAnnotationFactory> _rowAnnotationFactoryRef;

    public ValueMatchAnalyzerResult(InputColumn<?> column, RowAnnotationFactory rowAnnotationFactory, Map<String, RowAnnotation> valueAnnotations, RowAnnotation nullAnnotation, RowAnnotation nonMatchingValuesAnnotation, int totalCount) {
        this._column = column;
        this._rowAnnotationFactoryRef = new SerializableRef((Object)rowAnnotationFactory);
        this._valueAnnotations = valueAnnotations;
        this._nullAnnotation = nullAnnotation;
        this._nonMatchingValuesAnnotation = nonMatchingValuesAnnotation;
        this._totalCount = totalCount;
    }

    @Override
    public int getTotalCount() {
        return this._totalCount;
    }

    @Override
    @Metric(value="Null count")
    public int getNullCount() {
        return this._nullAnnotation.getRowCount();
    }

    @Override
    public Integer getCount(String value) {
        RowAnnotation annotation = this._valueAnnotations.get(value);
        if (annotation == null) {
            return null;
        }
        return annotation.getRowCount();
    }

    @Override
    @Metric(value="Unexpected value count")
    public Integer getUnexpectedValueCount() {
        return this._nonMatchingValuesAnnotation.getRowCount();
    }

    @Override
    public AnnotatedRowsResult getAnnotatedRowsForUnexpectedValues() {
        return new AnnotatedRowsResult(this._nonMatchingValuesAnnotation, (RowAnnotationFactory)this._rowAnnotationFactoryRef.get(), new InputColumn[]{this._column});
    }

    @Override
    public AnnotatedRowsResult getAnnotatedRowsForNull() {
        return new AnnotatedRowsResult(this._nullAnnotation, (RowAnnotationFactory)this._rowAnnotationFactoryRef.get(), new InputColumn[]{this._column});
    }

    @Override
    public AnnotatedRowsResult getAnnotatedRowsForValue(String value) {
        if (value == null) {
            return this.getAnnotatedRowsForNull();
        }
        if ("<unexpected>".equals(value)) {
            return this.getAnnotatedRowsForUnexpectedValues();
        }
        if (this._rowAnnotationFactoryRef.get() == null) {
            return null;
        }
        RowAnnotation annotation = this._valueAnnotations.get(value);
        if (annotation == null) {
            return null;
        }
        return new AnnotatedRowsResult(annotation, (RowAnnotationFactory)this._rowAnnotationFactoryRef.get(), new InputColumn[]{this._column});
    }

    public InputColumn<?> getColumn() {
        return this._column;
    }

    @Override
    public String getName() {
        return this._column.getName();
    }

    @Override
    public Collection<ValueFrequency> getValueCounts() {
        Integer unexpectedCount;
        TreeSet<ValueFrequency> result = new TreeSet<ValueFrequency>();
        for (Map.Entry<String, RowAnnotation> entry : this._valueAnnotations.entrySet()) {
            result.add(new SingleValueFrequency(entry.getKey(), entry.getValue().getRowCount()));
        }
        int nullCount = this.getNullCount();
        if (nullCount > 0) {
            result.add(new SingleValueFrequency(null, nullCount));
        }
        if ((unexpectedCount = this.getUnexpectedValueCount()) > 0) {
            result.add(new CompositeValueFrequency("<unexpected>", unexpectedCount));
        }
        return result;
    }

    public Map<String, RowAnnotation> getExpectedValueAnnotations() {
        return this._valueAnnotations;
    }

    @Override
    public Integer getDistinctCount() {
        return null;
    }

    @Override
    public Integer getUniqueCount() {
        return null;
    }

    @Override
    public Collection<String> getUniqueValues() {
        return null;
    }

    @Override
    public boolean hasAnnotatedRows(String value) {
        if (this._rowAnnotationFactoryRef.get() == null) {
            return false;
        }
        if (value == null) {
            return true;
        }
        if ("<unexpected>".equals(value)) {
            return true;
        }
        return this._valueAnnotations.containsKey(value);
    }
}

