/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.analyzer.beans.valuematch;

import java.util.Collection;
import java.util.HashMap;
import java.util.Set;
import javax.inject.Inject;
import org.eobjects.analyzer.beans.api.Provided;
import org.eobjects.analyzer.beans.valuematch.ValueMatchAnalyzerResult;
import org.eobjects.analyzer.data.InputColumn;
import org.eobjects.analyzer.data.InputRow;
import org.eobjects.analyzer.result.AnalyzerResultReducer;
import org.eobjects.analyzer.result.AnnotatedRowsResult;
import org.eobjects.analyzer.storage.RowAnnotation;
import org.eobjects.analyzer.storage.RowAnnotationFactory;

public class ValueMatchAnalyzerResultReducer
implements AnalyzerResultReducer<ValueMatchAnalyzerResult> {
    @Inject
    @Provided
    RowAnnotationFactory _rowAnnotationFactory;

    public ValueMatchAnalyzerResult reduce(Collection<? extends ValueMatchAnalyzerResult> analyzerResults) {
        ValueMatchAnalyzerResult firstResult = analyzerResults.iterator().next();
        InputColumn<?> column = firstResult.getColumn();
        RowAnnotation nullAnnotation = this._rowAnnotationFactory.createAnnotation();
        RowAnnotation unexpectedValuesAnnotation = this._rowAnnotationFactory.createAnnotation();
        HashMap<String, RowAnnotation> valueAnnotations = new HashMap<String, RowAnnotation>();
        int totalCount = 0;
        for (ValueMatchAnalyzerResult valueMatchAnalyzerResult : analyzerResults) {
            AnnotatedRowsResult slaveNullAnnotation = valueMatchAnalyzerResult.getAnnotatedRowsForNull();
            AnnotatedRowsResult slaveUnexpectedValuesAnnotation = valueMatchAnalyzerResult.getAnnotatedRowsForUnexpectedValues();
            totalCount += valueMatchAnalyzerResult.getTotalCount();
            this.reduce(nullAnnotation, slaveNullAnnotation);
            this.reduce(unexpectedValuesAnnotation, slaveUnexpectedValuesAnnotation);
            Set<String> expectedValues = valueMatchAnalyzerResult.getExpectedValueAnnotations().keySet();
            for (String expectedValue : expectedValues) {
                int slaveRowCount;
                AnnotatedRowsResult annotatedRowsResultForExpectedValue = valueMatchAnalyzerResult.getAnnotatedRowsForValue(expectedValue);
                if (annotatedRowsResultForExpectedValue == null || (slaveRowCount = annotatedRowsResultForExpectedValue.getAnnotatedRowCount()) <= 0) continue;
                RowAnnotation masterAnnotation = (RowAnnotation)valueAnnotations.get(expectedValue);
                if (masterAnnotation == null) {
                    masterAnnotation = this._rowAnnotationFactory.createAnnotation();
                    valueAnnotations.put(expectedValue, masterAnnotation);
                }
                this.reduce(masterAnnotation, annotatedRowsResultForExpectedValue);
            }
        }
        ValueMatchAnalyzerResult result = new ValueMatchAnalyzerResult(column, this._rowAnnotationFactory, valueAnnotations, nullAnnotation, unexpectedValuesAnnotation, totalCount);
        return result;
    }

    private void reduce(RowAnnotation annotation, AnnotatedRowsResult annotatedRowsResult) {
        if (annotatedRowsResult == null) {
            return;
        }
        int rowCount = annotatedRowsResult.getAnnotatedRowCount();
        if (rowCount == 0) {
            return;
        }
        InputRow[] rows = annotatedRowsResult.getRows();
        if (rows.length == rowCount) {
            this._rowAnnotationFactory.annotate(rows, annotation);
        } else {
            this._rowAnnotationFactory.transferAnnotations(annotatedRowsResult.getAnnotation(), annotation);
        }
    }
}

