/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.analyzer.result;

import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import org.eobjects.analyzer.result.CompositeValueFrequency;
import org.eobjects.analyzer.result.Metric;
import org.eobjects.analyzer.result.QueryParameterizableMetric;
import org.eobjects.analyzer.result.ValueCountingAnalyzerResult;
import org.eobjects.analyzer.result.ValueFrequency;
import org.eobjects.metamodel.util.CollectionUtils;
import org.eobjects.metamodel.util.Func;
import org.eobjects.metamodel.util.Predicate;

public abstract class AbstractValueCountingAnalyzerResult
implements ValueCountingAnalyzerResult {
    private static final long serialVersionUID = 1L;

    @Metric(value="Value count", supportsInClause=true)
    public final QueryParameterizableMetric getValueCount() {
        return new QueryParameterizableMetric(){

            public Collection<String> getParameterSuggestions() {
                Collection<ValueFrequency> valueCounts = AbstractValueCountingAnalyzerResult.this.getValueCounts();
                List result = CollectionUtils.map(valueCounts, (Func)new Func<ValueFrequency, String>(){

                    public String eval(ValueFrequency vc) {
                        return vc.getName();
                    }
                });
                result.remove(null);
                result.remove("<null>");
                result.remove("<unexpected>");
                return result;
            }

            public int getTotalCount() {
                return AbstractValueCountingAnalyzerResult.this.getTotalCount();
            }

            public int getInstanceCount(String instance) {
                Integer count = AbstractValueCountingAnalyzerResult.this.getCount(instance);
                if (count == null) {
                    return 0;
                }
                return count;
            }
        };
    }

    @Override
    public Collection<ValueFrequency> getReducedValueFrequencies(int preferredMaximum) {
        Collection<ValueFrequency> original = this.getValueCounts();
        TreeSet<ValueFrequency> result = new TreeSet<ValueFrequency>(original);
        if (original.size() <= preferredMaximum) {
            for (ValueFrequency valueFrequency : original) {
                List<ValueFrequency> children;
                if (!valueFrequency.isComposite() || (children = valueFrequency.getChildren()) == null || result.size() - 1 + children.size() > preferredMaximum) continue;
                result.remove(valueFrequency);
                result.addAll(children);
            }
            return result;
        }
        HashMap<Integer, LinkedList<ValueFrequency>> frequencyMap = new HashMap<Integer, LinkedList<ValueFrequency>>();
        for (ValueFrequency valueFrequency : original) {
            if (valueFrequency.isComposite()) continue;
            int count = valueFrequency.getCount();
            LinkedList<ValueFrequency> list = (LinkedList<ValueFrequency>)frequencyMap.get(count);
            if (list == null) {
                list = new LinkedList<ValueFrequency>();
                frequencyMap.put(count, list);
            }
            list.add(valueFrequency);
        }
        List allValues = frequencyMap.values();
        allValues = CollectionUtils.filter(allValues, (Predicate)new Predicate<List<ValueFrequency>>(){

            public Boolean eval(List<ValueFrequency> list) {
                return list.size() > 1;
            }
        });
        TreeSet values = new TreeSet(new Comparator<List<?>>(){

            @Override
            public int compare(List<?> o1, List<?> o2) {
                int diff = o2.size() - o1.size();
                if (diff == 0) {
                    return -1;
                }
                return diff;
            }
        });
        values.addAll(allValues);
        Iterator iterator = values.iterator();
        while (result.size() > preferredMaximum && iterator.hasNext()) {
            List groupChildren = (List)iterator.next();
            int groupFrequency = ((ValueFrequency)groupChildren.get(0)).getCount();
            String groupName = "<count=" + groupFrequency + ">";
            CompositeValueFrequency compositeValueFrequency = new CompositeValueFrequency(groupName, groupChildren);
            result.removeAll(groupChildren);
            result.add(compositeValueFrequency);
        }
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Value distribution for: ");
        sb.append(this.getName());
        this.appendToString(sb, this, 4);
        return sb.toString();
    }

    protected void appendToString(StringBuilder sb, ValueCountingAnalyzerResult groupResult, int maxEntries) {
        if (maxEntries != 0) {
            Collection<ValueFrequency> valueCounts = groupResult.getValueCounts();
            for (ValueFrequency valueCount : valueCounts) {
                sb.append("\n - ");
                sb.append(valueCount.getName());
                sb.append(": ");
                sb.append(valueCount.getCount());
                if (--maxEntries != 0) continue;
                sb.append("\n ...");
                break;
            }
        }
    }
}

