/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.analyzer.result;

import java.util.Collection;
import java.util.List;
import org.eobjects.analyzer.result.AbstractValueFrequency;
import org.eobjects.analyzer.result.SingleValueFrequency;
import org.eobjects.analyzer.result.ValueFrequency;
import org.eobjects.metamodel.util.CollectionUtils;
import org.eobjects.metamodel.util.Func;

public final class CompositeValueFrequency
extends AbstractValueFrequency
implements ValueFrequency {
    private static final long serialVersionUID = 1L;
    private final String _name;
    private final List<ValueFrequency> _children;
    private int _count;

    public CompositeValueFrequency(String name, List<ValueFrequency> children) {
        this._name = name;
        this._children = children;
        int sum = 0;
        for (ValueFrequency child : this._children) {
            sum += child.getCount();
        }
        this._count = sum;
    }

    public CompositeValueFrequency(String name, Collection<String> values, final int count) {
        this._name = name;
        this._children = CollectionUtils.map(values, (Func)new Func<String, ValueFrequency>(){

            public ValueFrequency eval(String str) {
                return new SingleValueFrequency(str, count);
            }
        });
        this._count = count * values.size();
    }

    public CompositeValueFrequency(String name, int count) {
        this._name = name;
        this._children = null;
        this._count = count;
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public int getCount() {
        return this._count;
    }

    @Override
    public boolean isComposite() {
        return true;
    }

    @Override
    public String getValue() {
        return null;
    }

    @Override
    public List<ValueFrequency> getChildren() {
        return this._children;
    }
}

