/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.analyzer.result;

import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.eobjects.analyzer.result.ValueCountList;
import org.eobjects.analyzer.result.ValueFrequency;

public class ValueCountListImpl
implements ValueCountList {
    private static final long serialVersionUID = 1L;
    private final boolean _retainHighest;
    private final int _maxSize;
    private final LinkedList<ValueFrequency> _values = new LinkedList();

    public static ValueCountListImpl createFullList() {
        return new ValueCountListImpl(-1, true);
    }

    public static ValueCountList emptyList() {
        return new ValueCountListImpl(0, true);
    }

    public static ValueCountListImpl createTopList(int topFrequentValues) {
        return new ValueCountListImpl(topFrequentValues, true);
    }

    public static ValueCountListImpl createBottomList(int bottomFrequentValues) {
        return new ValueCountListImpl(bottomFrequentValues, false);
    }

    private ValueCountListImpl(int maxSize, boolean retainHighest) {
        this._maxSize = maxSize;
        this._retainHighest = retainHighest;
    }

    public void register(ValueFrequency valueCount) {
        boolean inserted = false;
        if (this._retainHighest) {
            ListIterator<ValueFrequency> it = this._values.listIterator();
            while (it.hasNext()) {
                ValueFrequency v = (ValueFrequency)it.next();
                if (valueCount.getCount() <= v.getCount()) continue;
                it.previous();
                it.add(valueCount);
                inserted = true;
                it.next();
                this.trimValues();
                break;
            }
        } else {
            ListIterator<ValueFrequency> it = this._values.listIterator();
            while (it.hasNext()) {
                ValueFrequency v = (ValueFrequency)it.next();
                if (valueCount.getCount() >= v.getCount()) continue;
                it.previous();
                it.add(valueCount);
                inserted = true;
                it.next();
                this.trimValues();
                break;
            }
        }
        if (!(inserted || this._maxSize != -1 && this._maxSize <= this._values.size())) {
            this._values.add(valueCount);
        }
    }

    private void trimValues() {
        if (this._maxSize == -1) {
            return;
        }
        while (this._values.size() > this._maxSize) {
            this._values.removeLast();
        }
    }

    @Override
    public List<ValueFrequency> getValueCounts() {
        return this._values;
    }

    @Override
    public int getMaxSize() {
        return this._maxSize;
    }

    @Override
    public int getActualSize() {
        return this._values.size();
    }

    public String toString() {
        return "ValueCountList[" + this._values + "]";
    }
}

