/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.analyzer.beans.writers;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.concurrent.atomic.AtomicInteger;
import javax.inject.Inject;
import org.apache.commons.lang.ArrayUtils;
import org.eobjects.analyzer.beans.api.Analyzer;
import org.eobjects.analyzer.beans.api.AnalyzerBean;
import org.eobjects.analyzer.beans.api.Categorized;
import org.eobjects.analyzer.beans.api.ColumnProperty;
import org.eobjects.analyzer.beans.api.Concurrent;
import org.eobjects.analyzer.beans.api.Configured;
import org.eobjects.analyzer.beans.api.Description;
import org.eobjects.analyzer.beans.api.FileProperty;
import org.eobjects.analyzer.beans.api.Initialize;
import org.eobjects.analyzer.beans.api.SchemaProperty;
import org.eobjects.analyzer.beans.api.TableProperty;
import org.eobjects.analyzer.beans.api.Validate;
import org.eobjects.analyzer.beans.convert.ConvertToBooleanTransformer;
import org.eobjects.analyzer.beans.convert.ConvertToNumberTransformer;
import org.eobjects.analyzer.beans.writers.ErrorHandlingOption;
import org.eobjects.analyzer.beans.writers.WriteBuffer;
import org.eobjects.analyzer.beans.writers.WriteBufferSizeOption;
import org.eobjects.analyzer.beans.writers.WriteDataCategory;
import org.eobjects.analyzer.beans.writers.WriteDataResult;
import org.eobjects.analyzer.beans.writers.WriteDataResultImpl;
import org.eobjects.analyzer.connection.CsvDatastore;
import org.eobjects.analyzer.connection.Datastore;
import org.eobjects.analyzer.connection.FileDatastore;
import org.eobjects.analyzer.connection.UpdateableDatastore;
import org.eobjects.analyzer.connection.UpdateableDatastoreConnection;
import org.eobjects.analyzer.data.InputColumn;
import org.eobjects.analyzer.data.InputRow;
import org.eobjects.analyzer.util.SchemaNavigator;
import org.eobjects.metamodel.BatchUpdateScript;
import org.eobjects.metamodel.UpdateCallback;
import org.eobjects.metamodel.UpdateScript;
import org.eobjects.metamodel.UpdateableDataContext;
import org.eobjects.metamodel.create.TableCreationBuilder;
import org.eobjects.metamodel.csv.CsvDataContext;
import org.eobjects.metamodel.insert.RowInsertionBuilder;
import org.eobjects.metamodel.query.FilterItem;
import org.eobjects.metamodel.query.OperatorType;
import org.eobjects.metamodel.query.SelectItem;
import org.eobjects.metamodel.schema.Column;
import org.eobjects.metamodel.schema.ColumnType;
import org.eobjects.metamodel.schema.Schema;
import org.eobjects.metamodel.schema.Table;
import org.eobjects.metamodel.update.RowUpdationBuilder;
import org.eobjects.metamodel.util.Action;
import org.eobjects.metamodel.util.FileHelper;
import org.eobjects.metamodel.util.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AnalyzerBean(value="Update table")
@Description(value="Update records in a table in a registered datastore. This component allows you to map the values available in the flow with the columns of the target table, in order to update the values of these columns in the datastore.")
@Categorized(value={WriteDataCategory.class})
@Concurrent(value=true)
public class UpdateTableAnalyzer
implements Analyzer<WriteDataResult>,
Action<Iterable<Object[]>> {
    private static final File TEMP_DIR = FileHelper.getTempDir();
    private static final String ERROR_MESSAGE_COLUMN_NAME = "update_table_error_message";
    private static final Logger logger = LoggerFactory.getLogger(UpdateTableAnalyzer.class);
    @Inject
    @Configured
    @Description(value="Values to update in the table")
    InputColumn<?>[] values;
    @Inject
    @Configured
    @Description(value="Names of columns in the target table, on which the values will be updated.")
    @ColumnProperty
    String[] columnNames;
    @Inject
    @Configured
    @Description(value="Values that make up the condition of the table update")
    InputColumn<?>[] conditionValues;
    @Inject
    @Configured
    @Description(value="Names of columns in the target table, which form the conditions of the update.")
    @ColumnProperty
    String[] conditionColumnNames;
    @Inject
    @Configured
    @Description(value="Datastore to write to")
    UpdateableDatastore datastore;
    @Inject
    @Configured(required=false)
    @Description(value="Schema name of target table")
    @SchemaProperty
    String schemaName;
    @Inject
    @Configured(required=false)
    @Description(value="Table to target (update)")
    @TableProperty
    String tableName;
    @Inject
    @Configured(value="Buffer size")
    @Description(value="How much data to buffer before committing batches of data. Large batches often perform better, but require more memory.")
    WriteBufferSizeOption bufferSizeOption = WriteBufferSizeOption.MEDIUM;
    @Inject
    @Configured(value="How to handle updation errors?")
    ErrorHandlingOption errorHandlingOption = ErrorHandlingOption.STOP_JOB;
    @Inject
    @Configured(value="Error log file location", required=false)
    @Description(value="Directory or file path for saving erroneous records")
    @FileProperty(accessMode=FileProperty.FileAccessMode.SAVE, extension={".csv"})
    File errorLogFile = TEMP_DIR;
    @Inject
    @Configured(required=false)
    @Description(value="Additional values to write to error log")
    InputColumn<?>[] additionalErrorLogValues;
    private Column[] _targetColumns;
    private Column[] _targetConditionColumns;
    private WriteBuffer _writeBuffer;
    private AtomicInteger _updatedRowCount;
    private AtomicInteger _errorRowCount;
    private CsvDataContext _errorDataContext;

    @Validate
    public void validate() {
        if (this.values.length != this.columnNames.length) {
            throw new IllegalStateException("Values and column names should have equal length");
        }
        if (this.conditionValues.length != this.conditionColumnNames.length) {
            throw new IllegalStateException("Condition values and condition column names should have equal length");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Initialize
    public void init() throws IllegalArgumentException {
        if (logger.isDebugEnabled()) {
            logger.debug("At init() time, InputColumns are: {}", (Object)Arrays.toString(this.values));
        }
        this._errorRowCount = new AtomicInteger();
        this._updatedRowCount = new AtomicInteger();
        if (this.errorHandlingOption == ErrorHandlingOption.SAVE_TO_FILE) {
            this._errorDataContext = this.createErrorDataContext();
        }
        int bufferSize = this.bufferSizeOption.calculateBufferSize(this.values.length);
        logger.info("Row buffer size set to {}", (Object)bufferSize);
        this._writeBuffer = new WriteBuffer(bufferSize, this);
        UpdateableDatastoreConnection con = this.datastore.openConnection();
        try {
            int i;
            SchemaNavigator schemaNavigator = con.getSchemaNavigator();
            ArrayList<String> columnsNotFound = new ArrayList<String>();
            this._targetColumns = schemaNavigator.convertToColumns(this.schemaName, this.tableName, this.columnNames);
            for (i = 0; i < this._targetColumns.length; ++i) {
                if (this._targetColumns[i] != null) continue;
                columnsNotFound.add(this.columnNames[i]);
            }
            this._targetConditionColumns = schemaNavigator.convertToColumns(this.schemaName, this.tableName, this.conditionColumnNames);
            for (i = 0; i < this._targetConditionColumns.length; ++i) {
                if (this._targetConditionColumns[i] != null) continue;
                columnsNotFound.add(this.conditionColumnNames[i]);
            }
            if (!columnsNotFound.isEmpty()) {
                throw new IllegalArgumentException("Could not find column(s): " + columnsNotFound);
            }
        }
        finally {
            con.close();
        }
    }

    private void validateCsvHeaders(CsvDataContext dc) {
        Column column;
        Schema schema = dc.getDefaultSchema();
        if (schema.getTableCount() == 0) {
            return;
        }
        Table table = schema.getTables()[0];
        for (String string : this.columnNames) {
            Column column2 = table.getColumnByName(string);
            if (column2 != null) continue;
            throw new IllegalStateException("Error log file does not have required column header: " + string);
        }
        for (String string : this.conditionColumnNames) {
            Column column2 = table.getColumnByName(string);
            if (column2 != null) continue;
            throw new IllegalStateException("Error log file does not have required column header: " + string);
        }
        if (this.additionalErrorLogValues != null) {
            for (String string : this.additionalErrorLogValues) {
                String columnName = this.translateAdditionalErrorLogColumnName(string.getName());
                Column column3 = table.getColumnByName(columnName);
                if (column3 != null) continue;
                throw new IllegalStateException("Error log file does not have required column header: " + columnName);
            }
        }
        if ((column = table.getColumnByName(ERROR_MESSAGE_COLUMN_NAME)) == null) {
            throw new IllegalStateException("Error log file does not have required column: update_table_error_message");
        }
    }

    private String translateAdditionalErrorLogColumnName(String columnName) {
        if (ArrayUtils.contains((Object[])this.columnNames, (Object)columnName)) {
            return this.translateAdditionalErrorLogColumnName(columnName + "_add");
        }
        return columnName;
    }

    private CsvDataContext createErrorDataContext() {
        File file;
        if (this.errorLogFile == null || TEMP_DIR.equals(this.errorLogFile)) {
            try {
                file = File.createTempFile("updation_error", ".csv");
            }
            catch (IOException e) {
                throw new IllegalStateException("Could not create new temp file", e);
            }
        } else {
            file = this.errorLogFile.isDirectory() ? new File(this.errorLogFile, "updation_error_log.csv") : this.errorLogFile;
        }
        CsvDataContext dc = new CsvDataContext(file);
        final Schema schema = dc.getDefaultSchema();
        if (file.exists() && file.length() > 0L) {
            this.validateCsvHeaders(dc);
        } else {
            dc.executeUpdate(new UpdateScript(){

                public void run(UpdateCallback cb) {
                    TableCreationBuilder tableBuilder = cb.createTable(schema, "error_table");
                    for (String string : UpdateTableAnalyzer.this.columnNames) {
                        tableBuilder = tableBuilder.withColumn(string);
                    }
                    for (String string : UpdateTableAnalyzer.this.conditionColumnNames) {
                        tableBuilder = tableBuilder.withColumn(string);
                    }
                    if (UpdateTableAnalyzer.this.additionalErrorLogValues != null) {
                        for (String string : UpdateTableAnalyzer.this.additionalErrorLogValues) {
                            String columnName = UpdateTableAnalyzer.this.translateAdditionalErrorLogColumnName(string.getName());
                            tableBuilder = tableBuilder.withColumn(columnName);
                        }
                    }
                    tableBuilder = tableBuilder.withColumn(UpdateTableAnalyzer.ERROR_MESSAGE_COLUMN_NAME);
                    tableBuilder.execute();
                }
            });
        }
        return dc;
    }

    public void run(InputRow row, int distinctCount) {
        int i;
        if (logger.isDebugEnabled()) {
            logger.debug("At run() time, InputColumns are: {}", (Object)Arrays.toString(this.values));
        }
        Object[] rowData = this.additionalErrorLogValues == null ? new Object[this.values.length + this.conditionColumnNames.length] : new Object[this.values.length + this.conditionColumnNames.length + this.additionalErrorLogValues.length];
        for (i = 0; i < this.values.length; ++i) {
            rowData[i] = row.getValue(this.values[i]);
        }
        for (i = 0; i < this.conditionValues.length; ++i) {
            rowData[i + this.values.length] = row.getValue(this.conditionValues[i]);
        }
        if (this.additionalErrorLogValues != null) {
            for (i = 0; i < this.additionalErrorLogValues.length; ++i) {
                Object value;
                rowData[this.values.length + this.conditionColumnNames.length + i] = value = row.getValue(this.additionalErrorLogValues[i]);
            }
        }
        try {
            for (i = 0; i < this.values.length; ++i) {
                rowData[i] = this.convertType(rowData[i], this._targetColumns[i]);
                if (!logger.isDebugEnabled()) continue;
                logger.debug("Value for {} set to: {}", (Object)this.columnNames[i], rowData[i]);
            }
            for (i = 0; i < this.conditionValues.length; ++i) {
                int index = i + this.values.length;
                rowData[index] = this.convertType(rowData[index], this._targetConditionColumns[i]);
                if (!logger.isDebugEnabled()) continue;
                logger.debug("Value for {} set to: {}", (Object)this.conditionColumnNames[i], rowData[index]);
            }
        }
        catch (RuntimeException e) {
            for (int i2 = 0; i2 < distinctCount; ++i2) {
                this.errorOccurred(rowData, e);
            }
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Adding row data to buffer: {}", (Object)Arrays.toString(rowData));
        }
        for (i = 0; i < distinctCount; ++i) {
            this._writeBuffer.addToBuffer(rowData);
        }
    }

    private Object convertType(Object value, Column targetColumn) throws IllegalArgumentException {
        if (value == null) {
            return null;
        }
        Object result = value;
        ColumnType type = targetColumn.getType();
        if (type.isLiteral()) {
            if (value instanceof Number || value instanceof Date) {
                result = value.toString();
            }
        } else if (type.isNumber()) {
            Number numberValue = ConvertToNumberTransformer.transformValue((Object)value);
            if (numberValue == null && !"".equals(value)) {
                throw new IllegalArgumentException("Could not convert " + value + " to number");
            }
            result = numberValue;
        } else if (type == ColumnType.BOOLEAN) {
            Boolean booleanValue = ConvertToBooleanTransformer.transformValue((Object)value);
            if (booleanValue == null && !"".equals(value)) {
                throw new IllegalArgumentException("Could not convert " + value + " to boolean");
            }
            result = booleanValue;
        }
        return result;
    }

    public WriteDataResult getResult() {
        CsvDatastore errorDatastore;
        this._writeBuffer.flushBuffer();
        int updatedRowCount = this._updatedRowCount.get();
        if (this._errorDataContext != null) {
            Resource resource = this._errorDataContext.getResource();
            errorDatastore = new CsvDatastore(resource.getName(), resource);
        } else {
            errorDatastore = null;
        }
        return new WriteDataResultImpl(0, updatedRowCount, (Datastore)this.datastore, this.schemaName, this.tableName, this._errorRowCount.get(), (FileDatastore)errorDatastore);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(final Iterable<Object[]> buffer) throws Exception {
        UpdateableDatastoreConnection con = this.datastore.openConnection();
        try {
            Object[] updateColumns = con.getSchemaNavigator().convertToColumns(this.schemaName, this.tableName, this.columnNames);
            Column[] whereColumns = con.getSchemaNavigator().convertToColumns(this.schemaName, this.tableName, this.conditionColumnNames);
            if (logger.isDebugEnabled()) {
                logger.debug("Updating columns: {}", (Object)Arrays.toString(updateColumns));
            }
            UpdateableDataContext dc = con.getUpdateableDataContext();
            dc.executeUpdate((UpdateScript)new BatchUpdateScript((Column[])updateColumns, whereColumns){
                final /* synthetic */ Column[] val$updateColumns;
                final /* synthetic */ Column[] val$whereColumns;
                {
                    this.val$updateColumns = columnArray;
                    this.val$whereColumns = columnArray2;
                }

                public void run(UpdateCallback callback) {
                    for (Object[] rowData : buffer) {
                        Object value;
                        int i;
                        RowUpdationBuilder updationBuilder = callback.update(this.val$updateColumns[0].getTable());
                        for (i = 0; i < this.val$updateColumns.length; ++i) {
                            value = rowData[i];
                            updationBuilder = (RowUpdationBuilder)updationBuilder.value(this.val$updateColumns[i], value);
                        }
                        for (i = 0; i < this.val$whereColumns.length; ++i) {
                            value = rowData[i + this.val$updateColumns.length];
                            Column whereColumn = this.val$whereColumns[i];
                            FilterItem filterItem = new FilterItem(new SelectItem(whereColumn), OperatorType.EQUALS_TO, value);
                            updationBuilder = (RowUpdationBuilder)updationBuilder.where(new FilterItem[]{filterItem});
                        }
                        if (logger.isDebugEnabled()) {
                            logger.debug("Updating: {}", (Object)Arrays.toString(rowData));
                        }
                        try {
                            updationBuilder.execute();
                            UpdateTableAnalyzer.this._updatedRowCount.incrementAndGet();
                        }
                        catch (RuntimeException e) {
                            UpdateTableAnalyzer.this.errorOccurred(rowData, e);
                        }
                    }
                }
            });
        }
        finally {
            con.close();
        }
    }

    protected void errorOccurred(final Object[] rowData, final RuntimeException e) {
        this._errorRowCount.incrementAndGet();
        if (this.errorHandlingOption == ErrorHandlingOption.STOP_JOB) {
            throw e;
        }
        logger.warn("Error occurred while updating record. Writing to error stream", (Throwable)e);
        this._errorDataContext.executeUpdate(new UpdateScript(){

            public void run(UpdateCallback cb) {
                int i;
                RowInsertionBuilder insertBuilder = cb.insertInto(UpdateTableAnalyzer.this._errorDataContext.getDefaultSchema().getTables()[0]);
                for (i = 0; i < UpdateTableAnalyzer.this.columnNames.length; ++i) {
                    insertBuilder = (RowInsertionBuilder)insertBuilder.value(UpdateTableAnalyzer.this.columnNames[i], rowData[i]);
                }
                if (UpdateTableAnalyzer.this.additionalErrorLogValues != null) {
                    for (i = 0; i < UpdateTableAnalyzer.this.additionalErrorLogValues.length; ++i) {
                        String columnName = UpdateTableAnalyzer.this.translateAdditionalErrorLogColumnName(UpdateTableAnalyzer.this.additionalErrorLogValues[i].getName());
                        Object value = rowData[UpdateTableAnalyzer.this.columnNames.length + i];
                        insertBuilder = (RowInsertionBuilder)insertBuilder.value(columnName, value);
                    }
                }
                insertBuilder = (RowInsertionBuilder)insertBuilder.value(UpdateTableAnalyzer.ERROR_MESSAGE_COLUMN_NAME, (Object)e.getMessage());
                insertBuilder.execute();
            }
        });
    }
}

