/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.analyzer.beans.writers;

import java.util.ArrayList;
import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.eobjects.metamodel.util.Action;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class WriteBuffer {
    private static final Logger logger = LoggerFactory.getLogger(WriteBuffer.class);
    private final BlockingQueue<Object[]> _buffer;
    private final Action<Iterable<Object[]>> _flushAction;
    private final AtomicInteger _batchNumber;

    public WriteBuffer(int bufferSize, Action<Iterable<Object[]>> flushAction) {
        if (bufferSize <= 0) {
            throw new IllegalArgumentException("Buffer size must be a positive integer");
        }
        this._batchNumber = new AtomicInteger();
        this._buffer = new ArrayBlockingQueue<Object[]>(bufferSize);
        this._flushAction = flushAction;
    }

    protected Queue<Object[]> getBuffer() {
        return this._buffer;
    }

    public final void addToBuffer(Object[] rowData) {
        while (!this._buffer.offer(rowData)) {
            this.flushBuffer();
        }
    }

    public final void flushBuffer() {
        if (!this._buffer.isEmpty()) {
            int flushSize = this._buffer.size();
            logger.info("Flushing {} rows in write buffer", (Object)flushSize);
            ArrayList copy = new ArrayList(flushSize);
            this._buffer.drainTo(copy, flushSize);
            try {
                int batchNo = this._batchNumber.incrementAndGet();
                logger.info("Write batch no. {} starting", (Object)batchNo);
                this._flushAction.run(copy);
                logger.info("Write batch no. {} finished", (Object)batchNo);
            }
            catch (Exception e) {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new IllegalStateException(e);
            }
        }
    }
}

