/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.analyzer.beans.writers;

import org.eobjects.metamodel.util.HasName;

public enum WriteBufferSizeOption implements HasName
{
    HUGE("Huge (1M values)", 1000000),
    LARGE("Large (100k values)", 100000),
    MEDIUM("Medium (10k values)", 10000),
    SMALL("Small (1000 values)", 1000),
    TINY("Tiny (100 values)", 100);

    private final String _name;
    private final int _values;

    private WriteBufferSizeOption(String name, int values) {
        this._name = name;
        this._values = values;
    }

    public int getValues() {
        return this._values;
    }

    public String getName() {
        return this._name;
    }

    public int calculateBufferSize(int numColumns) {
        int objectsPerRow = numColumns + 1;
        int bufferSize = this._values / objectsPerRow;
        return Math.max(1, bufferSize);
    }
}

