/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.analyzer.beans.writers;

import org.eobjects.analyzer.beans.writers.WriteDataResult;
import org.eobjects.analyzer.connection.Datastore;
import org.eobjects.analyzer.connection.DatastoreCatalog;
import org.eobjects.analyzer.connection.DatastoreConnection;
import org.eobjects.analyzer.connection.FileDatastore;
import org.eobjects.metamodel.schema.Table;
import org.eobjects.metamodel.util.Func;

public final class WriteDataResultImpl
implements WriteDataResult {
    private static final long serialVersionUID = 1L;
    private final int _writtenRowCount;
    private final int _updatesCount;
    private final String _datastoreName;
    private final String _schemaName;
    private final String _tableName;
    private final int _errorRowCount;
    private final transient Func<DatastoreCatalog, Datastore> _datastoreFunc;
    private final transient FileDatastore _errorDatastore;

    public WriteDataResultImpl(int writtenRowCount, int updatesCount, int errorRowCount) {
        this(writtenRowCount, updatesCount, null, null, null, errorRowCount, null);
    }

    public WriteDataResultImpl(int writtenRowCount, Datastore datastore, String schemaName, String tableName) {
        this(writtenRowCount, datastore, schemaName, tableName, 0, null);
    }

    public WriteDataResultImpl(int writtenRowCount, Datastore datastore, String schemaName, String tableName, int errorRowCount, FileDatastore errorDatastore) {
        this(writtenRowCount, 0, datastore, schemaName, tableName, errorRowCount, errorDatastore);
    }

    public WriteDataResultImpl(int writtenRowCount, int updatesCount, final Datastore datastore, String schemaName, String tableName, int errorRowCount, FileDatastore errorDatastore) {
        this._writtenRowCount = writtenRowCount;
        this._updatesCount = updatesCount;
        this._schemaName = schemaName;
        this._tableName = tableName;
        this._datastoreName = datastore == null ? null : datastore.getName();
        this._datastoreFunc = new Func<DatastoreCatalog, Datastore>(){

            public Datastore eval(DatastoreCatalog catalog) {
                return datastore;
            }
        };
        this._errorRowCount = errorRowCount;
        this._errorDatastore = errorDatastore;
    }

    public WriteDataResultImpl(int writtenRowCount, String datastoreName, String schemaName, String tableName) {
        this(writtenRowCount, 0, datastoreName, schemaName, tableName);
    }

    public WriteDataResultImpl(int writtenRowCount, int updatesCount, final String datastoreName, String schemaName, String tableName) {
        this._writtenRowCount = writtenRowCount;
        this._updatesCount = updatesCount;
        this._schemaName = schemaName;
        this._tableName = tableName;
        this._datastoreName = datastoreName;
        this._datastoreFunc = new Func<DatastoreCatalog, Datastore>(){

            public Datastore eval(DatastoreCatalog catalog) {
                return catalog.getDatastore(datastoreName);
            }
        };
        this._errorRowCount = 0;
        this._errorDatastore = null;
    }

    @Override
    public FileDatastore getErrorDatastore() {
        return this._errorDatastore;
    }

    @Override
    public int getUpdatesCount() {
        return this._updatesCount;
    }

    @Override
    public int getErrorRowCount() {
        return this._errorRowCount;
    }

    @Override
    public int getWrittenRowCount() {
        return this._writtenRowCount;
    }

    @Override
    public Datastore getDatastore(DatastoreCatalog datastoreCatalog) {
        if (this._datastoreFunc == null) {
            if (this._datastoreName == null) {
                return null;
            }
            return datastoreCatalog.getDatastore(this._datastoreName);
        }
        return (Datastore)this._datastoreFunc.eval((Object)datastoreCatalog);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Table getPreviewTable(Datastore datastore) {
        DatastoreConnection con = datastore.openConnection();
        try {
            Table table = con.getSchemaNavigator().convertToTable(this._schemaName, this._tableName);
            return table;
        }
        finally {
            con.close();
        }
    }

    public String toString() {
        String message = this._writtenRowCount + " inserts executed";
        if (this._updatesCount > 0) {
            message = message + "\n" + this._updatesCount + " updates executed";
        }
        if (this._errorRowCount > 0) {
            message = this._errorDatastore == null ? message + "\n - WARNING! " + this._errorRowCount + " record failed" : message + "\n - WARNING! " + this._errorRowCount + " record failed, written to file: " + this._errorDatastore.getFilename();
        }
        return message;
    }
}

