/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.metamodel.access;

import com.healthmarketscience.jackcess.Database;
import com.healthmarketscience.jackcess.Index;
import com.healthmarketscience.jackcess.IndexData;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eobjects.metamodel.MetaModelException;
import org.eobjects.metamodel.QueryPostprocessDataContext;
import org.eobjects.metamodel.data.CachingDataSetHeader;
import org.eobjects.metamodel.data.DataSet;
import org.eobjects.metamodel.data.DataSetHeader;
import org.eobjects.metamodel.data.DefaultRow;
import org.eobjects.metamodel.data.InMemoryDataSet;
import org.eobjects.metamodel.query.FilterItem;
import org.eobjects.metamodel.query.SelectItem;
import org.eobjects.metamodel.schema.Column;
import org.eobjects.metamodel.schema.ColumnType;
import org.eobjects.metamodel.schema.MutableColumn;
import org.eobjects.metamodel.schema.MutableSchema;
import org.eobjects.metamodel.schema.MutableTable;
import org.eobjects.metamodel.schema.Schema;
import org.eobjects.metamodel.schema.Table;
import org.eobjects.metamodel.schema.TableType;

public final class AccessDataContext
extends QueryPostprocessDataContext {
    private final File _file;
    private Database _database;

    public AccessDataContext(File file) {
        this._file = file;
    }

    public AccessDataContext(String filename) {
        this(new File(filename));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Database getDatabase() {
        if (this._database == null) {
            AccessDataContext accessDataContext = this;
            synchronized (accessDataContext) {
                if (this._database == null) {
                    try {
                        this._database = Database.open((File)this._file, (boolean)true);
                    }
                    catch (IOException e) {
                        throw new MetaModelException((Exception)e);
                    }
                }
            }
        }
        return this._database;
    }

    protected Schema getMainSchema() throws MetaModelException {
        MutableSchema schema = new MutableSchema(this._file.getName());
        Database db = this.getDatabase();
        for (com.healthmarketscience.jackcess.Table mdbTable : db) {
            MutableTable table = new MutableTable(mdbTable.getName(), TableType.TABLE, (Schema)schema);
            try {
                int i = 0;
                for (com.healthmarketscience.jackcess.Column mdbColumn : mdbTable.getColumns()) {
                    ColumnType columnType = ColumnType.convertColumnType((int)mdbColumn.getSQLType());
                    MutableColumn column = new MutableColumn(mdbColumn.getName(), columnType, (Table)table, i, null);
                    column.setColumnSize(Integer.valueOf(mdbColumn.getLength()));
                    column.setNativeType(mdbColumn.getType().name());
                    table.addColumn((Column)column);
                    ++i;
                }
                Index primaryKeyIndex = mdbTable.getPrimaryKeyIndex();
                List columnDescriptors = primaryKeyIndex.getColumns();
                for (IndexData.ColumnDescriptor columnDescriptor : columnDescriptors) {
                    String name = columnDescriptor.getColumn().getName();
                    MutableColumn column = (MutableColumn)table.getColumnByName(name);
                    column.setPrimaryKey(true);
                }
                schema.addTable(table);
            }
            catch (Exception e) {
                throw new MetaModelException(e);
            }
        }
        return schema;
    }

    protected String getMainSchemaName() throws MetaModelException {
        return this._file.getName();
    }

    protected Number executeCountQuery(Table table, List<FilterItem> whereItems, boolean functionApproximationAllowed) {
        try {
            com.healthmarketscience.jackcess.Table mdbTable = this.getDatabase().getTable(table.getName());
            return mdbTable.getRowCount();
        }
        catch (Exception e) {
            throw new MetaModelException(e);
        }
    }

    public DataSet materializeMainSchemaTable(Table table, Column[] columns, int maxRows) {
        try {
            com.healthmarketscience.jackcess.Table mdbTable = this.getDatabase().getTable(table.getName());
            SelectItem[] selectItems = new SelectItem[columns.length];
            for (int i = 0; i < columns.length; ++i) {
                selectItems[i] = new SelectItem(columns[i]);
            }
            CachingDataSetHeader header = new CachingDataSetHeader(selectItems);
            int rowNum = 0;
            LinkedList<DefaultRow> data = new LinkedList<DefaultRow>();
            Iterator it = mdbTable.iterator();
            while (it.hasNext() && (maxRows < 0 || rowNum < maxRows)) {
                ++rowNum;
                Map valueMap = (Map)it.next();
                Object[] values = new Object[columns.length];
                for (int j = 0; j < columns.length; ++j) {
                    values[j] = valueMap.get(columns[j].getName());
                }
                data.add(new DefaultRow((DataSetHeader)header, values));
            }
            return new InMemoryDataSet((DataSetHeader)header, data);
        }
        catch (Exception e) {
            throw new MetaModelException(e);
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this._database.close();
    }
}

