/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.metamodel;

import java.util.Arrays;
import java.util.Map;
import java.util.TreeMap;
import org.eobjects.metamodel.DataContext;
import org.eobjects.metamodel.MetaModelException;
import org.eobjects.metamodel.SchemaNameComparator;
import org.eobjects.metamodel.data.DataSet;
import org.eobjects.metamodel.query.Query;
import org.eobjects.metamodel.query.builder.InitFromBuilder;
import org.eobjects.metamodel.query.builder.InitFromBuilderImpl;
import org.eobjects.metamodel.query.parser.QueryParser;
import org.eobjects.metamodel.schema.Column;
import org.eobjects.metamodel.schema.Schema;
import org.eobjects.metamodel.schema.Table;

public abstract class AbstractDataContext
implements DataContext {
    private final Map<String, Schema> _schemaCache = new TreeMap<String, Schema>(SchemaNameComparator.getInstance());
    private String[] _schemaNameCache;

    @Override
    public final DataContext refreshSchemas() {
        this._schemaCache.clear();
        this._schemaNameCache = null;
        return this;
    }

    @Override
    public final Schema[] getSchemas() throws MetaModelException {
        String[] schemaNames = this.getSchemaNames();
        for (int i = 0; i < schemaNames.length; ++i) {
            String name = schemaNames[i];
            if (this._schemaCache.containsKey(name)) continue;
            Schema schema = this.getSchemaByName(name);
            this._schemaCache.put(name, schema);
        }
        Schema[] result = this._schemaCache.values().toArray(new Schema[0]);
        return result;
    }

    @Override
    public final String[] getSchemaNames() throws MetaModelException {
        if (this._schemaNameCache == null) {
            this._schemaNameCache = this.getSchemaNamesInternal();
        }
        return Arrays.copyOf(this._schemaNameCache, this._schemaNameCache.length);
    }

    @Override
    public final Schema getDefaultSchema() throws MetaModelException {
        Schema result = null;
        String defaultSchemaName = this.getDefaultSchemaName();
        if (defaultSchemaName != null) {
            result = this.getSchemaByName(defaultSchemaName);
        }
        if (result == null) {
            Schema[] schemas = this.getSchemas();
            if (schemas.length == 1) {
                result = schemas[0];
            } else {
                int highestTableCount = -1;
                for (int i = 0; i < schemas.length; ++i) {
                    boolean isInformationSchema;
                    Schema schema = schemas[i];
                    String name = schema.getName().toLowerCase();
                    boolean bl = isInformationSchema = name.startsWith("information") && name.endsWith("schema");
                    if (isInformationSchema || schema.getTableCount() <= highestTableCount) continue;
                    highestTableCount = schema.getTableCount();
                    result = schema;
                }
            }
        }
        return result;
    }

    @Override
    public final InitFromBuilder query() {
        return new InitFromBuilderImpl(this);
    }

    @Override
    public Query parseQuery(String queryString) throws MetaModelException {
        QueryParser parser = new QueryParser(this, queryString);
        Query query = parser.parse();
        return query;
    }

    @Override
    public final DataSet executeQuery(String queryString) throws MetaModelException {
        Query query = this.parseQuery(queryString);
        DataSet dataSet = this.executeQuery(query);
        return dataSet;
    }

    @Override
    public final Schema getSchemaByName(String name) throws MetaModelException {
        Schema schema = this._schemaCache.get(name);
        if (schema == null) {
            if (name == null) {
                schema = this.getSchemaByNameInternal(null);
            } else {
                String[] schemaNames;
                for (String schemaName : schemaNames = this.getSchemaNames()) {
                    if (!name.equalsIgnoreCase(schemaName)) continue;
                    schema = this.getSchemaByNameInternal(name);
                    break;
                }
                if (schema == null) {
                    for (String schemaName : schemaNames) {
                        if (!name.equalsIgnoreCase(schemaName)) continue;
                        schema = this.getSchemaByNameInternal(schemaName);
                        break;
                    }
                }
            }
            if (schema != null) {
                this._schemaCache.put(schema.getName(), schema);
            }
        }
        return schema;
    }

    @Override
    public final Column getColumnByQualifiedLabel(String columnName) {
        Column column;
        String[] schemaNames;
        if (columnName == null) {
            return null;
        }
        Schema schema = null;
        for (String schemaName : schemaNames = this.getSchemaNames()) {
            if (schemaName == null) {
                Column column2;
                schema = this.getSchemaByName(null);
                if (schema == null || (column2 = this.getColumn(schema, columnName)) == null) continue;
                return column2;
            }
            Column col = this.searchColumn(schemaName, columnName, columnName);
            if (col == null) continue;
            return col;
        }
        String columnNameInLowerCase = columnName.toLowerCase();
        for (String schemaName : schemaNames) {
            String schameNameInLowerCase;
            Column col;
            if (schemaName == null || (col = this.searchColumn(schameNameInLowerCase = schemaName.toLowerCase(), columnName, columnNameInLowerCase)) == null) continue;
            return col;
        }
        schema = this.getDefaultSchema();
        if (schema != null && (column = this.getColumn(schema, columnName)) != null) {
            return column;
        }
        return null;
    }

    private Column searchColumn(String schemaNameSearch, String columnNameOriginal, String columnNameSearch) {
        Column column;
        String tableAndColumnPath;
        Schema schema;
        if (columnNameSearch.startsWith(schemaNameSearch) && (schema = this.getSchemaByName(schemaNameSearch)) != null && (tableAndColumnPath = columnNameOriginal.substring(schemaNameSearch.length())).charAt(0) == '.' && (column = this.getColumn(schema, tableAndColumnPath = tableAndColumnPath.substring(1))) != null) {
            return column;
        }
        return null;
    }

    private final Column getColumn(Schema schema, String tableAndColumnPath) {
        Column column;
        String[] tableNames;
        Table table = null;
        String columnPath = tableAndColumnPath;
        for (String tableName : tableNames = schema.getTableNames()) {
            if (tableName == null || !this.isStartingToken(tableName, tableAndColumnPath)) continue;
            table = schema.getTableByName(tableName);
            columnPath = tableAndColumnPath.substring(tableName.length());
            if (columnPath.charAt(0) != '.') continue;
            columnPath = columnPath.substring(1);
            break;
        }
        if (table == null) {
            String tableAndColumnPathInLowerCase = tableAndColumnPath.toLowerCase();
            for (String tableName : tableNames) {
                String tableNameInLowerCase;
                if (tableName == null || !this.isStartingToken(tableNameInLowerCase = tableName.toLowerCase(), tableAndColumnPathInLowerCase)) continue;
                table = schema.getTableByName(tableName);
                columnPath = tableAndColumnPath.substring(tableName.length());
                if (columnPath.charAt(0) != '.') continue;
                columnPath = columnPath.substring(1);
                break;
            }
        }
        if (table == null && tableNames.length == 1) {
            table = schema.getTables()[0];
        }
        if (table != null && (column = table.getColumnByName(columnPath)) != null) {
            return column;
        }
        return null;
    }

    @Override
    public final Table getTableByQualifiedLabel(String tableName) {
        String[] schemaNames;
        if (tableName == null) {
            return null;
        }
        Schema schema = null;
        for (String schemaName : schemaNames = this.getSchemaNames()) {
            if (schemaName == null) {
                schema = this.getSchemaByName(null);
                if (schema == null) continue;
                Table table = schema.getTableByName(tableName);
                return table;
            }
            if (!this.isStartingToken(schemaName, tableName)) continue;
            schema = this.getSchemaByName(schemaName);
        }
        if (schema == null) {
            String tableNameInLowerCase = tableName.toLowerCase();
            for (String schemaName : schemaNames) {
                String schemaNameInLowerCase;
                if (schemaName == null || !this.isStartingToken(schemaNameInLowerCase = schemaName.toLowerCase(), tableNameInLowerCase)) continue;
                schema = this.getSchemaByName(schemaName);
            }
        }
        if (schema == null) {
            schema = this.getDefaultSchema();
        }
        String tablePart = tableName.toLowerCase();
        String schemaName = schema.getName();
        if (schemaName != null && this.isStartingToken(schemaName.toLowerCase(), tablePart) && (tablePart = tablePart.substring(schemaName.length())).startsWith(".")) {
            tablePart = tablePart.substring(1);
        }
        return schema.getTableByName(tablePart);
    }

    private boolean isStartingToken(String partName, String fullName) {
        if (fullName.startsWith(partName)) {
            char nextChar;
            int length = partName.length();
            if (length == 0) {
                return false;
            }
            if (fullName.length() > length && this.isQualifiedPathDelim(nextChar = fullName.charAt(length))) {
                return true;
            }
        }
        return false;
    }

    protected boolean isQualifiedPathDelim(char c) {
        return c == '.' || c == '\"';
    }

    protected abstract String[] getSchemaNamesInternal();

    protected abstract String getDefaultSchemaName();

    protected abstract Schema getSchemaByNameInternal(String var1);
}

