/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.metamodel;

import org.eobjects.metamodel.DataContext;
import org.eobjects.metamodel.DeleteAndInsertBuilder;
import org.eobjects.metamodel.UpdateCallback;
import org.eobjects.metamodel.delete.RowDeletionBuilder;
import org.eobjects.metamodel.drop.TableDropBuilder;
import org.eobjects.metamodel.insert.RowInsertionBuilder;
import org.eobjects.metamodel.schema.Schema;
import org.eobjects.metamodel.schema.Table;
import org.eobjects.metamodel.update.RowUpdationBuilder;

public abstract class AbstractUpdateCallback
implements UpdateCallback {
    private final DataContext _dataContext;

    public AbstractUpdateCallback(DataContext dataContext) {
        this._dataContext = dataContext;
    }

    @Override
    public final RowInsertionBuilder insertInto(String tableName) throws IllegalArgumentException, IllegalStateException {
        return this.insertInto(this.getTable(tableName));
    }

    @Override
    public RowInsertionBuilder insertInto(String schemaName, String tableName) throws IllegalArgumentException, IllegalStateException, UnsupportedOperationException {
        return this.insertInto(this.getTable(schemaName, tableName));
    }

    private Table getTable(String schemaName, String tableName) {
        Schema schema = this._dataContext.getSchemaByName(schemaName);
        if (schema == null) {
            throw new IllegalArgumentException("No such schema: " + schemaName);
        }
        Table table = schema.getTableByName(tableName);
        if (table == null) {
            throw new IllegalArgumentException("No such table: " + tableName);
        }
        return table;
    }

    @Override
    public final RowDeletionBuilder deleteFrom(String tableName) {
        return this.deleteFrom(this.getTable(tableName));
    }

    @Override
    public RowDeletionBuilder deleteFrom(String schemaName, String tableName) throws IllegalArgumentException, IllegalStateException, UnsupportedOperationException {
        Table table = this.getTable(schemaName, tableName);
        return this.deleteFrom(table);
    }

    @Override
    public final TableDropBuilder dropTable(String tableName) {
        return this.dropTable(this.getTable(tableName));
    }

    @Override
    public final RowUpdationBuilder update(String tableName) {
        return this.update(this.getTable(tableName));
    }

    private Table getTable(String tableName) {
        Table table = this.getDataContext().getTableByQualifiedLabel(tableName);
        if (table == null) {
            throw new IllegalArgumentException("No such table: " + tableName);
        }
        return table;
    }

    @Override
    public DataContext getDataContext() {
        return this._dataContext;
    }

    @Override
    public boolean isCreateTableSupported() {
        return true;
    }

    @Override
    public boolean isInsertSupported() {
        return true;
    }

    @Override
    public boolean isUpdateSupported() {
        return this.isInsertSupported() && this.isDeleteSupported();
    }

    @Override
    public RowUpdationBuilder update(String schemaName, String tableName) throws IllegalArgumentException, IllegalStateException, UnsupportedOperationException {
        Table table = this.getTable(schemaName, tableName);
        return this.update(table);
    }

    @Override
    public RowUpdationBuilder update(Table table) throws IllegalArgumentException, IllegalStateException, UnsupportedOperationException {
        return new DeleteAndInsertBuilder(this, table);
    }
}

