/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.metamodel;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eobjects.metamodel.AbstractDataContext;
import org.eobjects.metamodel.MetaModelException;
import org.eobjects.metamodel.MetaModelHelper;
import org.eobjects.metamodel.convert.ConvertedDataSetInterceptor;
import org.eobjects.metamodel.convert.HasReadTypeConverters;
import org.eobjects.metamodel.convert.TypeConverter;
import org.eobjects.metamodel.data.DataSet;
import org.eobjects.metamodel.data.DefaultRow;
import org.eobjects.metamodel.data.EmptyDataSet;
import org.eobjects.metamodel.data.FirstRowDataSet;
import org.eobjects.metamodel.data.InMemoryDataSet;
import org.eobjects.metamodel.data.MaxRowsDataSet;
import org.eobjects.metamodel.data.Row;
import org.eobjects.metamodel.query.FilterItem;
import org.eobjects.metamodel.query.FromItem;
import org.eobjects.metamodel.query.GroupByItem;
import org.eobjects.metamodel.query.JoinType;
import org.eobjects.metamodel.query.OperatorType;
import org.eobjects.metamodel.query.OrderByItem;
import org.eobjects.metamodel.query.Query;
import org.eobjects.metamodel.query.SelectItem;
import org.eobjects.metamodel.schema.Column;
import org.eobjects.metamodel.schema.ColumnType;
import org.eobjects.metamodel.schema.MutableColumn;
import org.eobjects.metamodel.schema.MutableRelationship;
import org.eobjects.metamodel.schema.MutableSchema;
import org.eobjects.metamodel.schema.MutableTable;
import org.eobjects.metamodel.schema.Schema;
import org.eobjects.metamodel.schema.Table;
import org.eobjects.metamodel.schema.TableType;
import org.eobjects.metamodel.util.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class QueryPostprocessDataContext
extends AbstractDataContext
implements HasReadTypeConverters {
    private static final Logger logger = LoggerFactory.getLogger(QueryPostprocessDataContext.class);
    public static final String INFORMATION_SCHEMA_NAME = "information_schema";
    private final Map<Column, TypeConverter<?, ?>> _converters = new HashMap();
    private String[] _schemaNames;
    private Schema _mainSchema;

    @Override
    public DataSet executeQuery(Query query) {
        Integer firstRow;
        Integer maxRows;
        List<OrderByItem> orderByItems;
        List<FilterItem> havingItems;
        List<SelectItem> orderBySelectItems;
        List<SelectItem> havingSelectItems;
        List<SelectItem> groupBySelectItems;
        List<GroupByItem> groupByItems;
        List<SelectItem> whereSelectItems;
        List<FilterItem> whereItems;
        List fromItems;
        List<SelectItem> selectItems;
        block13: {
            Table table;
            SelectItem selectItem;
            selectItems = query.getSelectClause().getItems();
            fromItems = query.getFromClause().getItems();
            whereItems = query.getWhereClause().getItems();
            whereSelectItems = query.getWhereClause().getEvaluatedSelectItems();
            groupByItems = query.getGroupByClause().getItems();
            groupBySelectItems = query.getGroupByClause().getEvaluatedSelectItems();
            havingSelectItems = query.getHavingClause().getEvaluatedSelectItems();
            orderBySelectItems = query.getOrderByClause().getEvaluatedSelectItems();
            havingItems = query.getHavingClause().getItems();
            orderByItems = query.getOrderByClause().getItems();
            if (fromItems.size() == 1 && selectItems.size() == 1 && groupByItems.isEmpty() && havingItems.isEmpty() && SelectItem.isCountAllItem(selectItem = (SelectItem)query.getSelectClause().getItem(0))) {
                boolean functionApproximationAllowed = selectItem.isFunctionApproximationAllowed();
                FromItem fromItem = (FromItem)query.getFromClause().getItem(0);
                table = fromItem.getTable();
                if (table != null && this.isMainSchemaTable(table)) {
                    logger.debug("Query is a COUNT query with {} where items. Trying executeCountQuery(...)", (Object)whereItems.size());
                    Number count = this.executeCountQuery(table, whereItems, functionApproximationAllowed);
                    if (count == null) {
                        logger.debug("DataContext did not return any count query results. Proceeding with manual counting.");
                    } else {
                        ArrayList<Row> data = new ArrayList<Row>(1);
                        data.add(new DefaultRow(new SelectItem[]{selectItem}, new Object[]{count}));
                        return new InMemoryDataSet(data);
                    }
                }
            }
            maxRows = query.getMaxRows();
            firstRow = query.getFirstRow();
            if (maxRows != null && whereItems.isEmpty() && groupByItems.isEmpty() && havingItems.isEmpty() && orderByItems.isEmpty() && fromItems.size() == 1) {
                int rowsToMaterialize = firstRow == null ? maxRows : maxRows + (firstRow - 1);
                table = ((FromItem)fromItems.get(0)).getTable();
                if (table != null) {
                    for (SelectItem item : selectItems) {
                        if (item.getFunction() == null && item.getExpression() == null) continue;
                        break block13;
                    }
                    DataSet dataSet = this.materializeTable(table, selectItems, rowsToMaterialize);
                    dataSet = MetaModelHelper.getSelection(selectItems, dataSet);
                    if (firstRow != null) {
                        dataSet = new FirstRowDataSet(dataSet, firstRow);
                    }
                    return dataSet;
                }
            }
        }
        List<SelectItem> workSelectItems = CollectionUtils.concat(true, selectItems, whereSelectItems, groupBySelectItems, havingSelectItems, orderBySelectItems);
        DataSet[] fromDataSets = new DataSet[fromItems.size()];
        for (int i = 0; i < fromDataSets.length; ++i) {
            FromItem fromItem = (FromItem)fromItems.get(i);
            fromDataSets[i] = this.materializeFromItem(fromItem, workSelectItems);
        }
        DataSet dataSet = MetaModelHelper.getCarthesianProduct(fromDataSets, whereItems);
        dataSet = groupByItems.size() > 0 ? MetaModelHelper.getGrouped(workSelectItems, dataSet, groupByItems) : MetaModelHelper.getAggregated(workSelectItems, dataSet);
        dataSet = MetaModelHelper.getFiltered(dataSet, havingItems);
        if (query.getSelectClause().isDistinct()) {
            dataSet = MetaModelHelper.getSelection(selectItems, dataSet);
            dataSet = MetaModelHelper.getDistinct(dataSet);
            dataSet = MetaModelHelper.getOrdered(dataSet, orderByItems);
        } else {
            dataSet = MetaModelHelper.getOrdered(dataSet, orderByItems);
            dataSet = MetaModelHelper.getSelection(selectItems, dataSet);
        }
        if (firstRow != null) {
            dataSet = new FirstRowDataSet(dataSet, firstRow);
        }
        if (maxRows != null) {
            dataSet = new MaxRowsDataSet(dataSet, maxRows);
        }
        return dataSet;
    }

    protected Number executeCountQuery(Table table, List<FilterItem> whereItems, boolean functionApproximationAllowed) {
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected DataSet materializeFromItem(FromItem fromItem, List<SelectItem> selectItems) {
        DataSet dataSet;
        JoinType joinType = fromItem.getJoin();
        if (fromItem.getTable() != null) {
            Table table = fromItem.getTable();
            ArrayList<SelectItem> selectItemsToMaterialize = new ArrayList<SelectItem>();
            for (SelectItem selectItem : selectItems) {
                FromItem selectedFromItem = selectItem.getFromItem();
                if (selectedFromItem != null) {
                    if (!selectedFromItem.equals(fromItem)) continue;
                    selectItemsToMaterialize.add(selectItem.replaceFunction(null));
                    continue;
                }
                Column selectedColumn = selectItem.getColumn();
                if (selectedColumn == null || selectedColumn.getTable() == null || !selectedColumn.getTable().equals(table)) continue;
                selectItemsToMaterialize.add(selectItem.replaceFunction(null));
            }
            if (logger.isDebugEnabled()) {
                logger.debug("calling materializeTable(" + table.getName() + "," + selectItemsToMaterialize + ",-1");
            }
            dataSet = this.materializeTable(table, selectItemsToMaterialize, -1);
        } else if (joinType != null) {
            if (fromItem.getLeftSide() == null || fromItem.getRightSide() == null) {
                throw new IllegalArgumentException("Joined FromItem requires both left and right side: " + fromItem);
            }
            DataSet[] fromItemDataSets = new DataSet[2];
            List<SelectItem> leftOn = Arrays.asList(fromItem.getLeftOn());
            fromItemDataSets[0] = this.materializeFromItem(fromItem.getLeftSide(), CollectionUtils.concat(true, selectItems, leftOn));
            List<SelectItem> rightOn = Arrays.asList(fromItem.getRightOn());
            fromItemDataSets[1] = this.materializeFromItem(fromItem.getRightSide(), CollectionUtils.concat(true, selectItems, rightOn));
            FilterItem[] onConditions = new FilterItem[leftOn.size()];
            for (int i = 0; i < onConditions.length; ++i) {
                FilterItem whereItem;
                onConditions[i] = whereItem = new FilterItem(leftOn.get(i), OperatorType.EQUALS_TO, rightOn.get(i));
            }
            if (joinType == JoinType.INNER) {
                dataSet = MetaModelHelper.getCarthesianProduct(fromItemDataSets, onConditions);
            } else if (joinType == JoinType.LEFT) {
                dataSet = MetaModelHelper.getLeftJoin(fromItemDataSets[0], fromItemDataSets[1], onConditions);
            } else {
                if (joinType != JoinType.RIGHT) throw new IllegalArgumentException("FromItem type not supported: " + fromItem);
                dataSet = MetaModelHelper.getRightJoin(fromItemDataSets[0], fromItemDataSets[1], onConditions);
            }
        } else {
            if (fromItem.getSubQuery() == null) throw new IllegalArgumentException("FromItem type not supported: " + fromItem);
            dataSet = this.executeQuery(fromItem.getSubQuery());
        }
        if (dataSet != null) return dataSet;
        throw new IllegalStateException("FromItem was not succesfully materialized: " + fromItem);
    }

    protected DataSet materializeTable(Table table, List<SelectItem> selectItems, int maxRows) {
        if (table == null) {
            throw new IllegalArgumentException("Table cannot be null");
        }
        if (selectItems == null || selectItems.isEmpty()) {
            Column[] columns = table.getColumns();
            if (columns.length == 0) {
                logger.warn("Queried table has no columns: {}", (Object)table);
            } else {
                selectItems.add(new SelectItem(columns[0]));
            }
        }
        if (maxRows == 0) {
            return new EmptyDataSet(selectItems);
        }
        Schema schema = table.getSchema();
        String schemaName = schema == null ? null : schema.getName();
        if (INFORMATION_SCHEMA_NAME.equals(schemaName)) {
            return this.materializeInformationSchemaTable(table, selectItems, maxRows);
        }
        DataSet tableDataSet = this.materializeMainSchemaTable(table, selectItems, maxRows);
        tableDataSet = new ConvertedDataSetInterceptor(this._converters).intercept(tableDataSet);
        return tableDataSet;
    }

    protected boolean isMainSchemaTable(Table table) {
        Schema schema = table.getSchema();
        return !INFORMATION_SCHEMA_NAME.equals(schema.getName());
    }

    @Override
    protected final String[] getSchemaNamesInternal() throws MetaModelException {
        if (this._schemaNames == null) {
            this._schemaNames = new String[2];
            this._schemaNames[0] = INFORMATION_SCHEMA_NAME;
            this._schemaNames[1] = this.getMainSchemaName();
        }
        return Arrays.copyOf(this._schemaNames, this._schemaNames.length);
    }

    @Override
    protected String getDefaultSchemaName() throws MetaModelException {
        return this.getSchemaNames()[1];
    }

    @Override
    protected final Schema getSchemaByNameInternal(String name) throws MetaModelException {
        if (name != null) {
            if (name.equals(this.getSchemaNames()[1])) {
                return this.getMainSchemaInternal();
            }
            if (name.equals(INFORMATION_SCHEMA_NAME)) {
                return this.getInformationSchema();
            }
        }
        return null;
    }

    private Schema getInformationSchema() {
        MutableSchema informationSchema = new MutableSchema(INFORMATION_SCHEMA_NAME);
        MutableTable tablesTable = new MutableTable("tables", TableType.TABLE, informationSchema);
        MutableTable columnsTable = new MutableTable("columns", TableType.TABLE, informationSchema);
        MutableTable relationshipsTable = new MutableTable("relationships", TableType.TABLE, informationSchema);
        informationSchema.addTable(tablesTable).addTable(columnsTable).addTable(relationshipsTable);
        tablesTable.addColumn(new MutableColumn("name", ColumnType.VARCHAR, tablesTable, 0, false));
        tablesTable.addColumn(new MutableColumn("type", ColumnType.VARCHAR, tablesTable, 1, true));
        tablesTable.addColumn(new MutableColumn("num_columns", ColumnType.INTEGER, tablesTable, 2, true));
        tablesTable.addColumn(new MutableColumn("remarks", ColumnType.VARCHAR, tablesTable, 3, true));
        columnsTable.addColumn(new MutableColumn("name", ColumnType.VARCHAR, columnsTable, 0, false));
        columnsTable.addColumn(new MutableColumn("type", ColumnType.VARCHAR, columnsTable, 1, true));
        columnsTable.addColumn(new MutableColumn("native_type", ColumnType.VARCHAR, columnsTable, 2, true));
        columnsTable.addColumn(new MutableColumn("size", ColumnType.INTEGER, columnsTable, 3, true));
        columnsTable.addColumn(new MutableColumn("nullable", ColumnType.BOOLEAN, columnsTable, 4, true));
        columnsTable.addColumn(new MutableColumn("indexed", ColumnType.BOOLEAN, columnsTable, 5, true));
        columnsTable.addColumn(new MutableColumn("table", ColumnType.VARCHAR, columnsTable, 6, false));
        columnsTable.addColumn(new MutableColumn("remarks", ColumnType.VARCHAR, columnsTable, 7, true));
        relationshipsTable.addColumn(new MutableColumn("primary_table", ColumnType.VARCHAR, relationshipsTable, 0, false));
        relationshipsTable.addColumn(new MutableColumn("primary_column", ColumnType.VARCHAR, relationshipsTable, 1, false));
        relationshipsTable.addColumn(new MutableColumn("foreign_table", ColumnType.VARCHAR, relationshipsTable, 2, false));
        relationshipsTable.addColumn(new MutableColumn("foreign_column", ColumnType.VARCHAR, relationshipsTable, 3, false));
        MutableRelationship.createRelationship(tablesTable.getColumnByName("name"), columnsTable.getColumnByName("table"));
        MutableRelationship.createRelationship(tablesTable.getColumnByName("name"), relationshipsTable.getColumnByName("primary_table"));
        MutableRelationship.createRelationship(tablesTable.getColumnByName("name"), relationshipsTable.getColumnByName("foreign_table"));
        MutableRelationship.createRelationship(columnsTable.getColumnByName("name"), relationshipsTable.getColumnByName("primary_column"));
        MutableRelationship.createRelationship(columnsTable.getColumnByName("name"), relationshipsTable.getColumnByName("foreign_column"));
        return informationSchema;
    }

    private DataSet materializeInformationSchemaTable(Table table, List<SelectItem> selectItems, int maxRows) {
        String tableName = table.getName();
        SelectItem[] columnSelectItems = MetaModelHelper.createSelectItems(table.getColumns());
        Table[] tables = this.getMainSchemaInternal().getTables();
        ArrayList<Row> data = new ArrayList<Row>();
        if ("tables".equals(tableName)) {
            for (Table table2 : tables) {
                String typeString = null;
                if (table2.getType() != null) {
                    typeString = table2.getType().toString();
                }
                data.add(new DefaultRow(columnSelectItems, new Object[]{table2.getName(), typeString, table2.getColumnCount(), table2.getRemarks()}));
            }
        } else if ("columns".equals(tableName)) {
            for (Comparable<Table> comparable : tables) {
                for (Column c : comparable.getColumns()) {
                    String typeString = null;
                    if (comparable.getType() != null) {
                        typeString = c.getType().toString();
                    }
                    data.add(new DefaultRow(columnSelectItems, new Object[]{c.getName(), typeString, c.getNativeType(), c.getColumnSize(), c.isNullable(), c.isIndexed(), comparable.getName(), c.getRemarks()}));
                }
            }
        } else if ("relationships".equals(tableName)) {
            for (Comparable<Table> comparable : this.getMainSchemaInternal().getRelationships()) {
                Column[] primaryColumns = comparable.getPrimaryColumns();
                Column[] foreignColumns = comparable.getForeignColumns();
                Table pTable = comparable.getPrimaryTable();
                Table fTable = comparable.getForeignTable();
                for (int i = 0; i < primaryColumns.length; ++i) {
                    Column pColumn = primaryColumns[i];
                    Column fColumn = foreignColumns[i];
                    data.add(new DefaultRow(columnSelectItems, new Object[]{pTable.getName(), pColumn.getName(), fTable.getName(), fColumn.getName()}));
                }
            }
        } else {
            throw new IllegalArgumentException("Cannot materialize non information_schema table: " + table);
        }
        DataSet dataSet = data.isEmpty() ? new EmptyDataSet(selectItems) : new InMemoryDataSet(data);
        dataSet = MetaModelHelper.getSelection(selectItems, dataSet);
        if (maxRows != -1) {
            dataSet = new MaxRowsDataSet(dataSet, maxRows);
        }
        return dataSet;
    }

    protected Schema getMainSchemaInternal() {
        if (this._mainSchema == null) {
            this._mainSchema = this.getMainSchema();
        }
        return this._mainSchema;
    }

    @Override
    public void addConverter(Column column, TypeConverter<?, ?> converter) {
        this._converters.put(column, converter);
    }

    protected abstract Schema getMainSchema() throws MetaModelException;

    protected abstract String getMainSchemaName() throws MetaModelException;

    protected DataSet materializeMainSchemaTable(Table table, List<SelectItem> selectItems, int maxRows) {
        Column[] columns = new Column[selectItems.size()];
        for (int i = 0; i < columns.length; ++i) {
            columns[i] = selectItems.get(i).getColumn();
        }
        DataSet dataSet = this.materializeMainSchemaTable(table, columns, maxRows);
        dataSet = MetaModelHelper.getSelection(selectItems, dataSet);
        return dataSet;
    }

    protected abstract DataSet materializeMainSchemaTable(Table var1, Column[] var2, int var3);
}

