/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.metamodel.convert;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eobjects.metamodel.DataContext;
import org.eobjects.metamodel.MetaModelHelper;
import org.eobjects.metamodel.UpdateableDataContext;
import org.eobjects.metamodel.convert.ColumnTypeDetector;
import org.eobjects.metamodel.convert.ConvertedDataSetInterceptor;
import org.eobjects.metamodel.convert.ConvertedRowInsertionInterceptor;
import org.eobjects.metamodel.convert.ConvertedRowUpdationInterceptor;
import org.eobjects.metamodel.convert.HasReadTypeConverters;
import org.eobjects.metamodel.convert.TypeConverter;
import org.eobjects.metamodel.data.DataSet;
import org.eobjects.metamodel.data.Row;
import org.eobjects.metamodel.data.RowBuilder;
import org.eobjects.metamodel.data.Style;
import org.eobjects.metamodel.intercept.DataSetInterceptor;
import org.eobjects.metamodel.intercept.InterceptableDataContext;
import org.eobjects.metamodel.intercept.Interceptor;
import org.eobjects.metamodel.intercept.Interceptors;
import org.eobjects.metamodel.intercept.RowInsertionInterceptor;
import org.eobjects.metamodel.intercept.RowUpdationInterceptor;
import org.eobjects.metamodel.query.Query;
import org.eobjects.metamodel.schema.Column;
import org.eobjects.metamodel.schema.SuperColumnType;
import org.eobjects.metamodel.schema.Table;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Converters {
    private static final Logger logger = LoggerFactory.getLogger(Converters.class);

    private Converters() {
    }

    public static UpdateableDataContext addTypeConverter(UpdateableDataContext dataContext, Column column, TypeConverter<?, ?> converter) {
        return Converters.addTypeConverterInternally(dataContext, column, converter);
    }

    public static DataContext addTypeConverter(DataContext dataContext, Column column, TypeConverter<?, ?> converter) {
        return Converters.addTypeConverterInternally(dataContext, column, converter);
    }

    public static UpdateableDataContext addTypeConverters(UpdateableDataContext dataContext, Map<Column, TypeConverter<?, ?>> converters) {
        return Converters.addTypeConvertersInternally(dataContext, converters);
    }

    public static DataContext addTypeConverters(DataContext dataContext, Map<Column, TypeConverter<?, ?>> converters) {
        return Converters.addTypeConvertersInternally(dataContext, converters);
    }

    public static Map<Column, TypeConverter<?, ?>> autoDetectConverters(DataContext dataContext, Column[] columns, int sampleSize) {
        Table[] tables;
        columns = MetaModelHelper.getColumnsBySuperType(columns, SuperColumnType.LITERAL_TYPE);
        HashMap result = new HashMap();
        for (Table table : tables = MetaModelHelper.getTables(columns)) {
            Column[] tableColumns = MetaModelHelper.getTableColumns(table, columns);
            Converters.autoDetectConvertersInternally(dataContext, table, tableColumns, sampleSize, result);
        }
        return result;
    }

    public static Map<Column, TypeConverter<?, ?>> autoDetectConverters(DataContext dataContext, Table table, int sampleSize) {
        HashMap result = new HashMap();
        Column[] columns = table.getColumnsOfSuperType(SuperColumnType.LITERAL_TYPE);
        Converters.autoDetectConvertersInternally(dataContext, table, columns, sampleSize, result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void autoDetectConvertersInternally(DataContext dataContext, Table table, Column[] columns, int sampleSize, Map<Column, TypeConverter<?, ?>> result) {
        if (columns == null || columns.length == 0) {
            return;
        }
        HashMap<Column, ColumnTypeDetector> detectors = new HashMap<Column, ColumnTypeDetector>();
        for (Column column : columns) {
            detectors.put(column, new ColumnTypeDetector());
        }
        Query query = dataContext.query().from(table).select(columns).toQuery();
        if (sampleSize > 0 && sampleSize != Integer.MAX_VALUE) {
            query.setMaxRows(sampleSize);
        }
        DataSet dataSet = dataContext.executeQuery(query);
        try {
            while (dataSet.next()) {
                Row row = dataSet.getRow();
                for (Column column : columns) {
                    String stringValue = (String)row.getValue(column);
                    ColumnTypeDetector detector = (ColumnTypeDetector)detectors.get(column);
                    detector.registerValue(stringValue);
                }
            }
        }
        finally {
            dataSet.close();
        }
        for (Column column : columns) {
            ColumnTypeDetector detector = (ColumnTypeDetector)detectors.get(column);
            TypeConverter<?, ?> converter = detector.createConverter();
            if (converter == null) continue;
            result.put(column, converter);
        }
    }

    private static InterceptableDataContext addTypeConvertersInternally(DataContext dc, Map<Column, TypeConverter<?, ?>> converters) {
        if (converters == null) {
            throw new IllegalArgumentException("Converters cannot be null");
        }
        InterceptableDataContext interceptable = Interceptors.intercept(dc);
        Set<Map.Entry<Column, TypeConverter<?, ?>>> entries = converters.entrySet();
        for (Map.Entry<Column, TypeConverter<?, ?>> entry : entries) {
            Column column = entry.getKey();
            TypeConverter<?, ?> converter = entry.getValue();
            interceptable = Converters.addTypeConverterInternally(interceptable, column, converter);
        }
        return interceptable;
    }

    private static InterceptableDataContext addTypeConverterInternally(DataContext dc, Column column, TypeConverter<?, ?> converter) {
        if (column == null) {
            throw new IllegalArgumentException("Column cannot be null");
        }
        InterceptableDataContext interceptable = Interceptors.intercept(dc);
        DataContext delegate = interceptable.getDelegate();
        boolean interceptDataSets = true;
        if (delegate instanceof HasReadTypeConverters) {
            HasReadTypeConverters hasTypeConverter = (HasReadTypeConverters)((Object)delegate);
            hasTypeConverter.addConverter(column, converter);
            interceptDataSets = false;
        }
        Converters.addTypeConverterInterceptors(interceptable, column, converter, interceptDataSets);
        return interceptable;
    }

    private static void addTypeConverterInterceptors(InterceptableDataContext interceptable, Column column, TypeConverter<?, ?> converter, boolean interceptDataSets) {
        Interceptor<DataSet> interceptor;
        if (interceptDataSets) {
            interceptor = interceptable.getDataSetInterceptors().getInterceptorOfType(ConvertedDataSetInterceptor.class);
            if (interceptor == null) {
                interceptor = new ConvertedDataSetInterceptor();
                interceptable.addDataSetInterceptor((DataSetInterceptor)interceptor);
            }
            ((ConvertedDataSetInterceptor)interceptor).addConverter(column, converter);
        }
        if ((interceptor = interceptable.getRowInsertionInterceptors().getInterceptorOfType(ConvertedRowInsertionInterceptor.class)) == null) {
            interceptor = new ConvertedRowInsertionInterceptor();
            interceptable.addRowInsertionInterceptor((RowInsertionInterceptor)interceptor);
        }
        ((ConvertedRowInsertionInterceptor)interceptor).addConverter(column, converter);
        interceptor = interceptable.getRowUpdationInterceptors().getInterceptorOfType(ConvertedRowUpdationInterceptor.class);
        if (interceptor == null) {
            interceptor = new ConvertedRowUpdationInterceptor();
            interceptable.addRowUpdationInterceptor((RowUpdationInterceptor)interceptor);
        }
        ((ConvertedRowUpdationInterceptor)interceptor).addConverter(column, converter);
    }

    protected static <RB extends RowBuilder<?>> RB convertRow(RB rowBuilder, Map<Column, TypeConverter<?, ?>> converters) {
        Table table = rowBuilder.getTable();
        Column[] columns = table.getColumns();
        Row row = rowBuilder.toRow();
        for (Column column : columns) {
            TypeConverter<?, ?> converter = converters.get(column);
            if (converter == null) continue;
            int indexInRow = row.indexOf(column);
            Object value = row.getValue(indexInRow);
            Object physicalValue = converter.toPhysicalValue(value);
            logger.debug("Converted virtual value {} to {}", value, physicalValue);
            if (value == null && physicalValue == null && !rowBuilder.isSet(column)) {
                logger.debug("Omitting implicit null value for column: {}", (Object)column);
                continue;
            }
            Style style = row.getStyle(indexInRow);
            rowBuilder.value(column, physicalValue, style);
        }
        return rowBuilder;
    }
}

