/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.metamodel.convert;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.eobjects.metamodel.convert.TypeConverter;
import org.eobjects.metamodel.util.Func;
import org.eobjects.metamodel.util.TimeComparator;

public class StringToDateConverter
implements TypeConverter<String, Date> {
    private final Func<Date, String> _serializeFunc;
    private final Func<String, Date> _deserializeFunc;

    public StringToDateConverter() {
        this._deserializeFunc = new Func<String, Date>(){

            @Override
            public Date eval(String stringValue) {
                return TimeComparator.toDate(stringValue);
            }
        };
        this._serializeFunc = new Func<Date, String>(){

            @Override
            public String eval(Date date) {
                return DateFormat.getDateTimeInstance(2, 2).format(date);
            }
        };
    }

    public StringToDateConverter(String datePattern) {
        this(new SimpleDateFormat(datePattern));
    }

    public StringToDateConverter(final DateFormat dateFormat) {
        if (dateFormat == null) {
            throw new IllegalArgumentException("DateFormat cannot be null");
        }
        this._deserializeFunc = new Func<String, Date>(){

            @Override
            public Date eval(String string) {
                try {
                    return dateFormat.parse(string);
                }
                catch (ParseException e) {
                    throw new IllegalArgumentException("Could not parse date string: " + string);
                }
            }
        };
        this._serializeFunc = new Func<Date, String>(){

            @Override
            public String eval(Date date) {
                return dateFormat.format(date);
            }
        };
    }

    @Override
    public String toPhysicalValue(Date virtualValue) {
        if (virtualValue == null) {
            return null;
        }
        return this._serializeFunc.eval(virtualValue);
    }

    @Override
    public Date toVirtualValue(String physicalValue) {
        if (physicalValue == null || physicalValue.length() == 0) {
            return null;
        }
        return this._deserializeFunc.eval(physicalValue);
    }
}

