/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.metamodel.data;

import java.util.Arrays;
import org.eobjects.metamodel.data.DefaultRow;
import org.eobjects.metamodel.data.Row;
import org.eobjects.metamodel.data.RowBuilder;
import org.eobjects.metamodel.data.Style;
import org.eobjects.metamodel.query.SelectItem;
import org.eobjects.metamodel.schema.Column;
import org.eobjects.metamodel.schema.Table;

public abstract class AbstractRowBuilder<RB extends RowBuilder<?>>
implements RowBuilder<RB> {
    private final Column[] _columns;
    private final Object[] _values;
    private final Style[] _styles;
    private final boolean[] _explicitNulls;

    public AbstractRowBuilder(Table table) {
        this(table.getColumns());
    }

    public AbstractRowBuilder(Column[] columns) {
        this._columns = columns;
        this._explicitNulls = new boolean[this._columns.length];
        this._values = new Object[this._columns.length];
        this._styles = new Style[this._columns.length];
    }

    protected boolean[] getExplicitNulls() {
        return this._explicitNulls;
    }

    protected Object[] getValues() {
        return this._values;
    }

    protected Column[] getColumns() {
        return this._columns;
    }

    protected Style[] getStyles() {
        return this._styles;
    }

    @Override
    public final Row toRow() {
        return new DefaultRow(this.createSelectItems(), this._values);
    }

    private final SelectItem[] createSelectItems() {
        SelectItem[] selectItems = new SelectItem[this._columns.length];
        for (int i = 0; i < selectItems.length; ++i) {
            selectItems[i] = new SelectItem(this._columns[i]);
        }
        return selectItems;
    }

    @Override
    public final RB value(Column column, Object value) {
        return this.value(column, value, null);
    }

    @Override
    public RB value(Column column, Object value, Style style) {
        if (column == null) {
            throw new IllegalArgumentException("Column cannot be null");
        }
        boolean written = false;
        for (int i = 0; i < this._columns.length; ++i) {
            if (!this._columns[i].equals(column)) continue;
            this.value(i, value, style);
            written = true;
            break;
        }
        if (!written) {
            throw new IllegalArgumentException("No such column in table: " + column);
        }
        AbstractRowBuilder result = this;
        return (RB)result;
    }

    @Override
    public RB value(int columnIndex, Object value) {
        return this.value(columnIndex, value, null);
    }

    @Override
    public final RB value(int columnIndex, Object value, Style style) {
        this._values[columnIndex] = value;
        this._styles[columnIndex] = style;
        this._explicitNulls[columnIndex] = value == null;
        AbstractRowBuilder result = this;
        return (RB)result;
    }

    @Override
    public RB value(String columnName, Object value) {
        return this.value(columnName, value, null);
    }

    @Override
    public final RB value(String columnName, Object value, Style style) {
        if (columnName == null) {
            throw new IllegalArgumentException("Column name cannot be null");
        }
        for (int i = 0; i < this._columns.length; ++i) {
            Column column = this._columns[i];
            if (!column.getName().equalsIgnoreCase(columnName)) continue;
            return this.value(i, value, style);
        }
        throw new IllegalArgumentException("No such column in table: " + columnName + ", available columns are: " + Arrays.toString(this._columns));
    }

    @Override
    public boolean isSet(Column column) {
        for (int i = 0; i < this._columns.length; ++i) {
            if (!this._columns[i].equals(column)) continue;
            return this._values[i] != null || this._explicitNulls[i];
        }
        return false;
    }
}

