/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.metamodel.data;

import java.util.Arrays;
import java.util.List;
import org.eobjects.metamodel.data.Row;
import org.eobjects.metamodel.data.Style;
import org.eobjects.metamodel.query.SelectItem;
import org.eobjects.metamodel.schema.Column;
import org.eobjects.metamodel.util.BaseObject;

public final class DefaultRow
extends BaseObject
implements Cloneable,
Row {
    private static final long serialVersionUID = 1L;
    private final List<SelectItem> _items;
    private final Object[] _values;
    private final Style[] _styles;

    public DefaultRow(SelectItem[] items, Object[] values) {
        this(Arrays.asList(items), values, null);
    }

    public DefaultRow(SelectItem[] items, Object[] values, Style[] styles) {
        this(Arrays.asList(items), values, styles);
    }

    public DefaultRow(List<SelectItem> items, Object[] values) {
        this(items, values, null);
    }

    public DefaultRow(List<SelectItem> items, Object[] values, Style[] styles) {
        if (items == null) {
            throw new IllegalArgumentException("Select items cannot be null");
        }
        if (values == null) {
            throw new IllegalArgumentException("Select items cannot be null");
        }
        if (items.size() != values.length) {
            throw new IllegalArgumentException("SelectItems length and values length must be equal. " + items.size() + " select items present and encountered these values: " + Arrays.toString(values));
        }
        if (styles != null) {
            if (items.size() != styles.length) {
                throw new IllegalArgumentException("SelectItems length and styles length must be equal. " + items.size() + " select items present and encountered these values: " + Arrays.toString(styles));
            }
            boolean entirelyNoStyle = true;
            for (int i = 0; i < styles.length; ++i) {
                if (styles[i] == null) {
                    throw new IllegalArgumentException("Elements in the style array cannot be null");
                }
                if (!entirelyNoStyle || Style.NO_STYLE.equals(styles[i])) continue;
                entirelyNoStyle = false;
            }
            if (entirelyNoStyle) {
                styles = null;
            }
        }
        this._items = items;
        this._values = values;
        this._styles = styles;
    }

    @Override
    public Object getValue(SelectItem item) {
        if (item == null) {
            return null;
        }
        int i = 0;
        for (SelectItem selectItem : this._items) {
            if (item == selectItem) {
                return this._values[i];
            }
            ++i;
        }
        i = 0;
        for (SelectItem selectItem : this._items) {
            if (item.equalsIgnoreAlias(selectItem, true)) {
                return this._values[i];
            }
            ++i;
        }
        i = 0;
        for (SelectItem selectItem : this._items) {
            if (item.equalsIgnoreAlias(selectItem)) {
                return this._values[i];
            }
            ++i;
        }
        return null;
    }

    @Override
    public Object getValue(Column column) {
        int index = this.indexOf(column);
        if (index == -1) {
            return null;
        }
        return this.getValue(index);
    }

    @Override
    public int indexOf(SelectItem item) {
        if (item == null) {
            return -1;
        }
        int i = 0;
        for (SelectItem selectItem : this._items) {
            if (item.equalsIgnoreAlias(selectItem)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public int indexOf(Column column) {
        if (column == null) {
            return -1;
        }
        SelectItem selectItem = new SelectItem(column);
        return this.indexOf(selectItem);
    }

    @Override
    public Object getValue(int index) throws ArrayIndexOutOfBoundsException {
        return this._values[index];
    }

    @Override
    public SelectItem[] getSelectItems() {
        return this._items.toArray(new SelectItem[this._items.size()]);
    }

    @Override
    public Object[] getValues() {
        return this._values;
    }

    @Override
    public String toString() {
        return "Row[values=" + Arrays.toString(this._values) + "]";
    }

    @Override
    protected void decorateIdentity(List<Object> identifiers) {
        identifiers.add(this._items);
        identifiers.add(this._values);
        identifiers.add(this._styles);
    }

    protected DefaultRow clone() {
        return new DefaultRow(this._items, this._values, this._styles);
    }

    @Override
    public Row getSubSelection(SelectItem[] selectItems) {
        Object[] values = new Object[selectItems.length];
        Style[] styles = new Style[selectItems.length];
        for (int i = 0; i < selectItems.length; ++i) {
            SelectItem selectItem = selectItems[i];
            if (selectItem.getSubQuerySelectItem() != null) {
                values[i] = this.getValue(selectItem.getSubQuerySelectItem());
                styles[i] = this.getStyle(selectItem.getSubQuerySelectItem());
                if (values[i] != null) continue;
                values[i] = this.getValue(selectItem);
                styles[i] = this.getStyle(selectItem);
                continue;
            }
            values[i] = this.getValue(selectItem);
            styles[i] = this.getStyle(selectItem);
        }
        return new DefaultRow(selectItems, values, styles);
    }

    @Override
    public Style getStyle(SelectItem item) {
        if (this._styles == null) {
            return Style.NO_STYLE;
        }
        return this._styles[this.indexOf(item)];
    }

    @Override
    public Style getStyle(Column column) {
        if (this._styles == null) {
            return Style.NO_STYLE;
        }
        return this._styles[this.indexOf(column)];
    }

    @Override
    public Style getStyle(int index) throws IndexOutOfBoundsException {
        if (this._styles == null) {
            return Style.NO_STYLE;
        }
        return this._styles[index];
    }

    @Override
    public int size() {
        return this._items.size();
    }
}

