/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.metamodel.data;

import org.eobjects.metamodel.data.AbstractDataSet;
import org.eobjects.metamodel.data.DataSet;
import org.eobjects.metamodel.data.Row;
import org.eobjects.metamodel.query.SelectItem;

public final class FirstRowDataSet
extends AbstractDataSet {
    private final DataSet _dataSet;
    private volatile int _rowsLeftToSkip;

    public FirstRowDataSet(DataSet dataSet, int firstRow) {
        this._dataSet = dataSet;
        if (firstRow <= 0) {
            throw new IllegalArgumentException("First row cannot be negative or zero");
        }
        this._rowsLeftToSkip = firstRow - 1;
    }

    @Override
    public void close() {
        this._dataSet.close();
    }

    @Override
    public Row getRow() {
        return this._dataSet.getRow();
    }

    @Override
    public SelectItem[] getSelectItems() {
        return this._dataSet.getSelectItems();
    }

    @Override
    public boolean next() {
        boolean next = true;
        if (this._rowsLeftToSkip > 0) {
            while (this._rowsLeftToSkip > 0) {
                next = this._dataSet.next();
                if (next) {
                    --this._rowsLeftToSkip;
                    continue;
                }
                this._rowsLeftToSkip = 0;
                return false;
            }
        }
        return this._dataSet.next();
    }
}

