/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.metamodel.data;

import java.util.Arrays;
import java.util.List;
import org.eobjects.metamodel.data.AbstractDataSet;
import org.eobjects.metamodel.data.EmptyDataSet;
import org.eobjects.metamodel.data.Row;
import org.eobjects.metamodel.query.SelectItem;

public final class InMemoryDataSet
extends AbstractDataSet {
    private final SelectItem[] _selectItems;
    private final List<Row> _rows;
    private int _rowNumber = -1;

    public InMemoryDataSet(Row ... rows) {
        this(Arrays.asList(rows));
    }

    public InMemoryDataSet(List<Row> rows) {
        this._rows = rows;
        if (rows.isEmpty()) {
            throw new IllegalArgumentException("Cannot hold an empty list of rows, use " + EmptyDataSet.class + " for this");
        }
        this._selectItems = rows.get(0).getSelectItems();
    }

    @Override
    public SelectItem[] getSelectItems() {
        return this._selectItems;
    }

    @Override
    public boolean next() {
        ++this._rowNumber;
        return this._rowNumber < this._rows.size();
    }

    @Override
    public Row getRow() {
        if (this._rowNumber < 0 || this._rowNumber >= this._rows.size()) {
            return null;
        }
        Row row = this._rows.get(this._rowNumber);
        assert (row.size() == this._selectItems.length);
        return row;
    }

    public List<Row> getRows() {
        return this._rows;
    }

    public int size() {
        return this._rows.size();
    }
}

