/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.metamodel.data;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.eobjects.metamodel.MetaModelException;
import org.eobjects.metamodel.data.DefaultRow;
import org.eobjects.metamodel.data.Row;
import org.eobjects.metamodel.data.RowPublisher;
import org.eobjects.metamodel.data.RowPublisherDataSet;
import org.eobjects.metamodel.data.Style;

class RowPublisherImpl
implements RowPublisher {
    public static final int BUFFER_SIZE = 20;
    private final RowPublisherDataSet _dataSet;
    private final BlockingQueue<Row> _queue;
    private final AtomicBoolean _finished;
    private final AtomicInteger _rowCount;
    private volatile Row _currentRow;
    private volatile Exception _error;

    public RowPublisherImpl(RowPublisherDataSet dataSet) {
        this._dataSet = dataSet;
        this._queue = new ArrayBlockingQueue<Row>(20);
        this._finished = new AtomicBoolean(false);
        this._rowCount = new AtomicInteger();
    }

    @Override
    public boolean publish(Row row) {
        if (this._finished.get()) {
            return false;
        }
        while (!this.offer(row)) {
            if (!this._finished.get()) continue;
            return false;
        }
        int rowCount = this._rowCount.incrementAndGet();
        if (this._dataSet.getMaxRows() > 0 && rowCount >= this._dataSet.getMaxRows()) {
            this.finished();
            return false;
        }
        return true;
    }

    private boolean offer(Row row) {
        try {
            return this._queue.offer(row, 1000L, TimeUnit.MICROSECONDS);
        }
        catch (InterruptedException e) {
            return false;
        }
    }

    @Override
    public boolean publish(Object[] values) {
        DefaultRow row = new DefaultRow(this._dataSet.getSelectItems(), values);
        return this.publish(row);
    }

    @Override
    public boolean publish(Object[] values, Style[] styles) {
        DefaultRow row = new DefaultRow(this._dataSet.getSelectItems(), values, styles);
        return this.publish(row);
    }

    @Override
    public void finished() {
        this._finished.set(true);
    }

    public boolean next() {
        if (this._queue.isEmpty() && this._finished.get()) {
            return false;
        }
        try {
            this._currentRow = this._queue.poll(1000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (this._currentRow != null) {
            return true;
        }
        if (this._error != null) {
            if (this._error instanceof RuntimeException) {
                throw (RuntimeException)this._error;
            }
            throw new MetaModelException(this._error);
        }
        return this.next();
    }

    public Row getRow() {
        return this._currentRow;
    }

    public void failed(Exception error) {
        this._error = error;
    }
}

