/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.metamodel.data;

import java.util.List;
import org.eobjects.metamodel.data.Style;
import org.eobjects.metamodel.util.BaseObject;

final class StyleImpl
extends BaseObject
implements Style {
    private static final long serialVersionUID = 1L;
    private final boolean _underline;
    private final boolean _italic;
    private final boolean _bold;
    private final Integer _fontSize;
    private final Style.TextAlignment _alignment;
    private final Style.Color _backgroundColor;
    private final Style.Color _foregroundColor;
    private final Style.SizeUnit _fontSizeUnit;

    public StyleImpl() {
        this(false, false, false, null, null, null, null, null);
    }

    public StyleImpl(boolean bold, boolean italic, boolean underline, Integer fontSize, Style.SizeUnit fontSizeUnit, Style.TextAlignment alignment, Style.Color backgroundColor, Style.Color foregroundColor) {
        this._bold = bold;
        this._italic = italic;
        this._underline = underline;
        this._fontSize = fontSize;
        this._fontSizeUnit = fontSizeUnit;
        this._alignment = alignment;
        this._backgroundColor = backgroundColor;
        this._foregroundColor = foregroundColor;
    }

    @Override
    public boolean isBold() {
        return this._bold;
    }

    @Override
    public boolean isItalic() {
        return this._italic;
    }

    @Override
    public boolean isUnderline() {
        return this._underline;
    }

    @Override
    public Integer getFontSize() {
        return this._fontSize;
    }

    @Override
    public Style.SizeUnit getFontSizeUnit() {
        return this._fontSizeUnit;
    }

    @Override
    public Style.TextAlignment getAlignment() {
        return this._alignment;
    }

    @Override
    public Style.Color getForegroundColor() {
        return this._foregroundColor;
    }

    @Override
    public Style.Color getBackgroundColor() {
        return this._backgroundColor;
    }

    @Override
    public String toCSS() {
        StringBuilder sb = new StringBuilder();
        if (this._bold) {
            sb.append("font-weight: bold;");
        }
        if (this._italic) {
            sb.append("font-style: italic;");
        }
        if (this._underline) {
            sb.append("text-decoration: underline;");
        }
        if (this._alignment != null) {
            sb.append("text-align: " + this.toCSS(this._alignment) + ";");
        }
        if (this._fontSize != null) {
            sb.append("font-size: " + this._fontSize);
            switch (this._fontSizeUnit) {
                case PT: {
                    sb.append("pt");
                    break;
                }
                case PX: {
                    sb.append("px");
                    break;
                }
                case PERCENT: {
                    sb.append("%");
                    break;
                }
            }
            sb.append(';');
        }
        if (this._foregroundColor != null) {
            sb.append("color: " + this.toCSS(this._foregroundColor) + ";");
        }
        if (this._backgroundColor != null) {
            sb.append("background-color: " + this.toCSS(this._backgroundColor) + ";");
        }
        return sb.toString();
    }

    private String toCSS(Style.Color c) {
        return "rgb(" + c.getRed() + "," + c.getGreen() + "," + c.getBlue() + ")";
    }

    @Override
    public String toString() {
        return this.toCSS();
    }

    private String toCSS(Style.TextAlignment alignment) {
        switch (alignment) {
            case LEFT: {
                return "left";
            }
            case RIGHT: {
                return "right";
            }
            case CENTER: {
                return "center";
            }
            case JUSTIFY: {
                return "justify";
            }
        }
        throw new IllegalStateException("Unknown alignment: " + (Object)((Object)alignment));
    }

    @Override
    protected void decorateIdentity(List<Object> identifiers) {
        identifiers.add(this._underline);
        identifiers.add(this._italic);
        identifiers.add(this._bold);
        identifiers.add(this._fontSize);
        identifiers.add((Object)this._fontSizeUnit);
        identifiers.add((Object)this._alignment);
        identifiers.add(this._backgroundColor);
        identifiers.add(this._foregroundColor);
    }
}

