/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.metamodel.insert;

import org.eobjects.metamodel.UpdateCallback;
import org.eobjects.metamodel.data.AbstractRowBuilder;
import org.eobjects.metamodel.data.Row;
import org.eobjects.metamodel.insert.RowInsertionBuilder;
import org.eobjects.metamodel.query.SelectItem;
import org.eobjects.metamodel.schema.Column;
import org.eobjects.metamodel.schema.Table;

public abstract class AbstractRowInsertionBuilder<U extends UpdateCallback>
extends AbstractRowBuilder<RowInsertionBuilder>
implements RowInsertionBuilder {
    private final U _updateCallback;
    private final Table _table;

    public AbstractRowInsertionBuilder(U updateCallback, Table table) {
        super(table);
        this._updateCallback = updateCallback;
        this._table = table;
    }

    @Override
    public Table getTable() {
        return this._table;
    }

    protected U getUpdateCallback() {
        return this._updateCallback;
    }

    @Override
    public RowInsertionBuilder like(Row row) {
        SelectItem[] selectItems = row.getSelectItems();
        for (int i = 0; i < selectItems.length; ++i) {
            SelectItem selectItem = selectItems[i];
            Column column = selectItem.getColumn();
            if (column == null) continue;
            if (this._table == column.getTable()) {
                this.value(column, row.getValue(i));
                continue;
            }
            this.value(column.getName(), row.getValue(i));
        }
        return this;
    }

    @Override
    public String toSql() {
        StringBuilder sb = new StringBuilder();
        sb.append("INSERT INTO ");
        sb.append(this._table.getQualifiedLabel());
        sb.append("(");
        Column[] columns = this.getColumns();
        for (int i = 0; i < columns.length; ++i) {
            if (i != 0) {
                sb.append(',');
            }
            sb.append(columns[i].getName());
        }
        sb.append(") VALUES (");
        Object[] values = this.getValues();
        for (int i = 0; i < values.length; ++i) {
            Object value = values[i];
            String stringValue = value == null ? "NULL" : (value instanceof String ? "\"" + value + "\"" : value.toString());
            sb.append(stringValue);
        }
        sb.append(")");
        return sb.toString();
    }

    public String toString() {
        return this.toSql();
    }
}

