/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.metamodel.intercept;

import org.eobjects.metamodel.AbstractUpdateCallback;
import org.eobjects.metamodel.UpdateCallback;
import org.eobjects.metamodel.create.TableCreationBuilder;
import org.eobjects.metamodel.delete.RowDeletionBuilder;
import org.eobjects.metamodel.drop.TableDropBuilder;
import org.eobjects.metamodel.insert.RowInsertionBuilder;
import org.eobjects.metamodel.intercept.InterceptableDataContext;
import org.eobjects.metamodel.intercept.InterceptableRowDeletionBuilder;
import org.eobjects.metamodel.intercept.InterceptableRowInsertionBuilder;
import org.eobjects.metamodel.intercept.InterceptableRowUpdationBuilder;
import org.eobjects.metamodel.intercept.InterceptableTableCreationBuilder;
import org.eobjects.metamodel.intercept.InterceptableTableDropBuilder;
import org.eobjects.metamodel.intercept.InterceptorList;
import org.eobjects.metamodel.schema.Schema;
import org.eobjects.metamodel.schema.Table;
import org.eobjects.metamodel.update.RowUpdationBuilder;

final class InterceptableUpdateCallback
extends AbstractUpdateCallback
implements UpdateCallback {
    private final UpdateCallback _updateCallback;
    private final InterceptorList<TableCreationBuilder> _tableCreationInterceptors;
    private final InterceptorList<TableDropBuilder> _tableDropInterceptors;
    private final InterceptorList<RowInsertionBuilder> _rowInsertionInterceptors;
    private final InterceptorList<RowUpdationBuilder> _rowUpdationInterceptors;
    private final InterceptorList<RowDeletionBuilder> _rowDeletionInterceptors;

    public InterceptableUpdateCallback(InterceptableDataContext dataContext, UpdateCallback updateCallback, InterceptorList<TableCreationBuilder> tableCreationInterceptors, InterceptorList<TableDropBuilder> tableDropInterceptors, InterceptorList<RowInsertionBuilder> rowInsertionInterceptors, InterceptorList<RowUpdationBuilder> rowUpdationInterceptors, InterceptorList<RowDeletionBuilder> rowDeletionInterceptors) {
        super(dataContext);
        this._updateCallback = updateCallback;
        this._tableCreationInterceptors = tableCreationInterceptors;
        this._tableDropInterceptors = tableDropInterceptors;
        this._rowInsertionInterceptors = rowInsertionInterceptors;
        this._rowUpdationInterceptors = rowUpdationInterceptors;
        this._rowDeletionInterceptors = rowDeletionInterceptors;
    }

    @Override
    public TableCreationBuilder createTable(Schema schema, String name) throws IllegalArgumentException, IllegalStateException {
        TableCreationBuilder tabelCreationBuilder = this._updateCallback.createTable(schema, name);
        if (this._tableCreationInterceptors.isEmpty()) {
            return tabelCreationBuilder;
        }
        return new InterceptableTableCreationBuilder(tabelCreationBuilder, this._tableCreationInterceptors);
    }

    @Override
    public RowInsertionBuilder insertInto(Table table) throws IllegalArgumentException, IllegalStateException {
        RowInsertionBuilder rowInsertionBuilder = this._updateCallback.insertInto(table);
        if (this._rowInsertionInterceptors.isEmpty()) {
            return rowInsertionBuilder;
        }
        return new InterceptableRowInsertionBuilder(rowInsertionBuilder, this._rowInsertionInterceptors);
    }

    @Override
    public boolean isCreateTableSupported() {
        return this._updateCallback.isCreateTableSupported();
    }

    @Override
    public boolean isDropTableSupported() {
        return this._updateCallback.isDropTableSupported();
    }

    @Override
    public TableDropBuilder dropTable(Table table) {
        TableDropBuilder tableDropBuilder = this._updateCallback.dropTable(table);
        if (this._tableDropInterceptors.isEmpty()) {
            return tableDropBuilder;
        }
        return new InterceptableTableDropBuilder(tableDropBuilder, this._tableDropInterceptors);
    }

    @Override
    public boolean isInsertSupported() {
        return this._updateCallback.isInsertSupported();
    }

    @Override
    public boolean isUpdateSupported() {
        return this._updateCallback.isUpdateSupported();
    }

    @Override
    public RowUpdationBuilder update(Table table) {
        RowUpdationBuilder rowUpdationBuilder = this._updateCallback.update(table);
        if (this._rowUpdationInterceptors.isEmpty()) {
            return rowUpdationBuilder;
        }
        return new InterceptableRowUpdationBuilder(rowUpdationBuilder, this._rowUpdationInterceptors);
    }

    @Override
    public boolean isDeleteSupported() {
        return this._updateCallback.isDeleteSupported();
    }

    @Override
    public RowDeletionBuilder deleteFrom(Table table) {
        RowDeletionBuilder rowDeletionBuilder = this._updateCallback.deleteFrom(table);
        if (this._rowDeletionInterceptors.isEmpty()) {
            return rowDeletionBuilder;
        }
        return new InterceptableRowDeletionBuilder(rowDeletionBuilder, this._rowDeletionInterceptors);
    }
}

