/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.metamodel.query;

import java.util.List;
import org.eobjects.metamodel.query.JoinType;
import org.eobjects.metamodel.query.Query;
import org.eobjects.metamodel.query.QueryItem;
import org.eobjects.metamodel.query.SelectItem;
import org.eobjects.metamodel.schema.Column;
import org.eobjects.metamodel.schema.Relationship;
import org.eobjects.metamodel.schema.Table;
import org.eobjects.metamodel.util.BaseObject;

public class FromItem
extends BaseObject
implements QueryItem,
Cloneable {
    private static final long serialVersionUID = -6559220014058975193L;
    private Table _table;
    private String _alias;
    private Query _subQuery;
    private JoinType _join;
    private FromItem _leftSide;
    private FromItem _rightSide;
    private SelectItem[] _leftOn;
    private SelectItem[] _rightOn;
    private Query _query;
    private String _expression;

    private FromItem() {
    }

    public FromItem(Table table) {
        this._table = table;
    }

    public FromItem(Query subQuery) {
        this._subQuery = subQuery;
    }

    public FromItem(JoinType join, Relationship relationship) {
        int i;
        this._join = join;
        this._leftSide = new FromItem(relationship.getPrimaryTable());
        Column[] columns = relationship.getPrimaryColumns();
        this._leftOn = new SelectItem[columns.length];
        for (i = 0; i < columns.length; ++i) {
            this._leftOn[i] = new SelectItem(columns[i]);
        }
        this._rightSide = new FromItem(relationship.getForeignTable());
        columns = relationship.getForeignColumns();
        this._rightOn = new SelectItem[columns.length];
        for (i = 0; i < columns.length; ++i) {
            this._rightOn[i] = new SelectItem(columns[i]);
        }
    }

    public FromItem(JoinType join, FromItem leftSide, FromItem rightSide, SelectItem[] leftOn, SelectItem[] rightOn) {
        this._join = join;
        this._leftSide = leftSide;
        this._rightSide = rightSide;
        this._leftOn = leftOn;
        this._rightOn = rightOn;
    }

    public FromItem(String expression) {
        if (expression == null) {
            throw new IllegalArgumentException("Expression cannot be null");
        }
        this._expression = expression;
    }

    public String getAlias() {
        return this._alias;
    }

    public String getSameQueryAlias() {
        if (this._alias != null) {
            return this._alias;
        }
        if (this._table != null) {
            return this._table.getQuotedName();
        }
        return null;
    }

    public FromItem setAlias(String alias) {
        this._alias = alias;
        return this;
    }

    public Table getTable() {
        return this._table;
    }

    public Query getSubQuery() {
        return this._subQuery;
    }

    public JoinType getJoin() {
        return this._join;
    }

    public FromItem getLeftSide() {
        return this._leftSide;
    }

    public FromItem getRightSide() {
        return this._rightSide;
    }

    public SelectItem[] getLeftOn() {
        return this._leftOn;
    }

    public SelectItem[] getRightOn() {
        return this._rightOn;
    }

    public String getExpression() {
        return this._expression;
    }

    @Override
    public String toSql() {
        StringBuilder sb = new StringBuilder(this.toStringNoAlias());
        if (this._join != null && this._alias != null) {
            sb.insert(0, '(');
            sb.append(')');
        }
        if (this._alias != null) {
            sb.append(' ');
            sb.append(this._alias);
        }
        return sb.toString();
    }

    public String toStringNoAlias() {
        if (this._expression != null) {
            return this._expression;
        }
        StringBuilder sb = new StringBuilder();
        if (this._table != null) {
            if (this._table.getSchema() != null && this._table.getSchema().getName() != null) {
                sb.append(this._table.getSchema().getName() + '.');
            }
            sb.append(this._table.getQuotedName());
        } else if (this._subQuery != null) {
            sb.append('(' + this._subQuery.toString() + ')');
        } else if (this._join != null) {
            String leftSideAlias = this._leftSide.getSameQueryAlias();
            String rightSideAlias = this._rightSide.getSameQueryAlias();
            sb.append(this._leftSide.toSql() + ' ' + (Object)((Object)this._join) + " JOIN " + this._rightSide.toSql());
            for (int i = 0; i < this._leftOn.length; ++i) {
                if (i == 0) {
                    sb.append(" ON ");
                } else {
                    sb.append(" AND ");
                }
                SelectItem primary = this._leftOn[i];
                SelectItem foreign = this._rightOn[i];
                if (leftSideAlias != null) {
                    sb.append(leftSideAlias + '.');
                }
                sb.append(primary.getSuperQueryAlias());
                sb.append(" = ");
                if (rightSideAlias != null) {
                    sb.append(rightSideAlias + '.');
                }
                sb.append(foreign.getSuperQueryAlias());
            }
        }
        return sb.toString();
    }

    public String getAlias(Table table) {
        String result = null;
        if (table != null) {
            if (table.equals(this._table)) {
                result = this._alias;
            } else if (this._join != null && (result = this._rightSide.getAlias(table)) == null) {
                result = this._leftSide.getAlias(table);
            }
        }
        return result;
    }

    @Override
    public Query getQuery() {
        return this._query;
    }

    @Override
    public QueryItem setQuery(Query query) {
        this._query = query;
        return this;
    }

    protected FromItem clone() {
        FromItem f = new FromItem();
        f._alias = this._alias;
        f._join = this._join;
        f._table = this._table;
        f._expression = this._expression;
        if (this._subQuery != null) {
            f._subQuery = this._subQuery.clone();
        }
        if (this._leftOn != null && this._leftSide != null && this._rightOn != null && this._rightSide != null) {
            f._leftSide = this._leftSide.clone();
            f._leftOn = (SelectItem[])this._leftOn.clone();
            f._rightSide = this._rightSide.clone();
            f._rightOn = (SelectItem[])this._rightOn.clone();
        }
        return f;
    }

    @Override
    protected void decorateIdentity(List<Object> identifiers) {
        identifiers.add(this._table);
        identifiers.add(this._alias);
        identifiers.add(this._subQuery);
        identifiers.add((Object)this._join);
        identifiers.add(this._leftSide);
        identifiers.add(this._rightSide);
        identifiers.add(this._leftOn);
        identifiers.add(this._rightOn);
        identifiers.add(this._expression);
    }

    @Override
    public String toString() {
        return this.toSql();
    }
}

