/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.metamodel.query;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.eobjects.metamodel.MetaModelException;
import org.eobjects.metamodel.query.FilterClause;
import org.eobjects.metamodel.query.FilterItem;
import org.eobjects.metamodel.query.FromClause;
import org.eobjects.metamodel.query.FromItem;
import org.eobjects.metamodel.query.FunctionType;
import org.eobjects.metamodel.query.GroupByClause;
import org.eobjects.metamodel.query.GroupByItem;
import org.eobjects.metamodel.query.JoinType;
import org.eobjects.metamodel.query.LogicalOperator;
import org.eobjects.metamodel.query.OperatorType;
import org.eobjects.metamodel.query.OrderByClause;
import org.eobjects.metamodel.query.OrderByItem;
import org.eobjects.metamodel.query.SelectClause;
import org.eobjects.metamodel.query.SelectItem;
import org.eobjects.metamodel.query.parser.QueryPartCollectionProcessor;
import org.eobjects.metamodel.query.parser.QueryPartParser;
import org.eobjects.metamodel.query.parser.QueryPartProcessor;
import org.eobjects.metamodel.query.parser.SelectItemParser;
import org.eobjects.metamodel.schema.Column;
import org.eobjects.metamodel.schema.Table;
import org.eobjects.metamodel.util.BaseObject;
import org.eobjects.metamodel.util.NumberComparator;

public final class Query
extends BaseObject
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -5976325207498574216L;
    private final SelectClause _selectClause = new SelectClause(this);
    private final FromClause _fromClause = new FromClause(this);
    private final FilterClause _whereClause = new FilterClause(this, " WHERE ");
    private final GroupByClause _groupByClause = new GroupByClause(this);
    private final FilterClause _havingClause = new FilterClause(this, " HAVING ");
    private final OrderByClause _orderByClause = new OrderByClause(this);
    private Integer _maxRows;
    private Integer _firstRow;

    public Query select(Column column, FromItem fromItem) {
        SelectItem selectItem = new SelectItem(column, fromItem);
        return this.select(selectItem);
    }

    public Query select(Column ... columns) {
        for (Column column : columns) {
            SelectItem selectItem = new SelectItem(column);
            selectItem.setQuery(this);
            this._selectClause.addItem(selectItem);
        }
        return this;
    }

    public Query select(SelectItem ... items) {
        this._selectClause.addItems(items);
        return this;
    }

    public Query select(FunctionType functionType, Column column) {
        this._selectClause.addItem(new SelectItem(functionType, column));
        return this;
    }

    public Query select(String expression, String alias) {
        return this.select(new SelectItem(expression, alias));
    }

    public Query select(String expression) {
        if ("*".equals(expression)) {
            return this.selectAll();
        }
        SelectItem selectItem = this.findSelectItem(expression, true);
        return this.select(selectItem);
    }

    private SelectItem findSelectItem(String expression, boolean allowExpressionBasedSelectItem) {
        SelectItemParser parser = new SelectItemParser(this, allowExpressionBasedSelectItem);
        return parser.findSelectItem(expression);
    }

    public Query selectAll() {
        List items = this.getFromClause().getItems();
        for (FromItem fromItem : items) {
            if (fromItem.getTable() == null) {
                throw new MetaModelException("All select items ('*') not determinable with from item: " + fromItem);
            }
            Column[] columns = fromItem.getTable().getColumns();
            this.select(columns);
        }
        return this;
    }

    public Query selectDistinct() {
        this._selectClause.setDistinct(true);
        return this;
    }

    public Query selectCount() {
        return this.select(SelectItem.getCountAllItem());
    }

    public Query from(FromItem ... items) {
        this._fromClause.addItems(items);
        return this;
    }

    public Query from(Table table) {
        return this.from(new FromItem(table));
    }

    public Query from(String expression) {
        return this.from(new FromItem(expression));
    }

    public Query from(Table table, String alias) {
        return this.from(new FromItem(table).setAlias(alias));
    }

    public Query from(Table leftTable, Table rightTable, JoinType joinType, Column leftOnColumn, Column rightOnColumn) {
        SelectItem[] leftOn = new SelectItem[]{new SelectItem(leftOnColumn)};
        SelectItem[] rightOn = new SelectItem[]{new SelectItem(rightOnColumn)};
        FromItem fromItem = new FromItem(joinType, new FromItem(leftTable), new FromItem(rightTable), leftOn, rightOn);
        return this.from(fromItem);
    }

    public Query groupBy(String ... groupByTokens) {
        for (String groupByToken : groupByTokens) {
            SelectItem selectItem = this.findSelectItem(groupByToken, true);
            this.groupBy(new GroupByItem(selectItem));
        }
        return this;
    }

    public Query groupBy(GroupByItem ... items) {
        for (GroupByItem item : items) {
            SelectItem selectItem = item.getSelectItem();
            if (selectItem == null || selectItem.getQuery() != null) continue;
            selectItem.setQuery(this);
        }
        this._groupByClause.addItems(items);
        return this;
    }

    public Query groupBy(Column ... columns) {
        for (Column column : columns) {
            SelectItem selectItem = new SelectItem(column).setQuery(this);
            this._groupByClause.addItem(new GroupByItem(selectItem));
        }
        return this;
    }

    public Query orderBy(OrderByItem ... items) {
        this._orderByClause.addItems(items);
        return this;
    }

    public Query orderBy(String ... orderByTokens) {
        for (String orderByToken : orderByTokens) {
            OrderByItem.Direction direction;
            if ((orderByToken = orderByToken.trim()).toUpperCase().endsWith("DESC")) {
                direction = OrderByItem.Direction.DESC;
                orderByToken = orderByToken.substring(0, orderByToken.length() - 4).trim();
            } else if (orderByToken.toUpperCase().endsWith("ASC")) {
                direction = OrderByItem.Direction.ASC;
                orderByToken = orderByToken.substring(0, orderByToken.length() - 3).trim();
            } else {
                direction = OrderByItem.Direction.ASC;
            }
            OrderByItem orderByItem = new OrderByItem(this.findSelectItem(orderByToken, true), direction);
            this.orderBy(orderByItem);
        }
        return this;
    }

    public Query orderBy(Column column) {
        return this.orderBy(column, OrderByItem.Direction.ASC);
    }

    @Deprecated
    public Query orderBy(Column column, boolean ascending) {
        if (ascending) {
            return this.orderBy(column, OrderByItem.Direction.ASC);
        }
        return this.orderBy(column, OrderByItem.Direction.DESC);
    }

    public Query orderBy(Column column, OrderByItem.Direction direction) {
        SelectItem selectItem = this._selectClause.getSelectItem(column);
        if (selectItem == null) {
            selectItem = new SelectItem(column);
        }
        return this.orderBy(new OrderByItem(selectItem, direction));
    }

    public Query where(FilterItem ... items) {
        this._whereClause.addItems(items);
        return this;
    }

    public Query where(Iterable<FilterItem> items) {
        this._whereClause.addItems(items);
        return this;
    }

    public Query where(String ... whereItemTokens) {
        for (String whereItemToken : whereItemTokens) {
            FilterItem filterItem = this.findFilterItem(whereItemToken);
            this.where(filterItem);
        }
        return this;
    }

    private FilterItem findFilterItem(String expression) {
        ArrayList operand;
        OperatorType[] operators;
        QueryPartCollectionProcessor collectionProcessor = new QueryPartCollectionProcessor();
        new QueryPartParser(collectionProcessor, expression, " AND ", " OR ").parse();
        List<String> tokens = collectionProcessor.getTokens();
        List<String> delims = collectionProcessor.getDelims();
        if (tokens.size() != 1) {
            LogicalOperator logicalOperator = LogicalOperator.valueOf(delims.get(1).trim());
            ArrayList<FilterItem> filterItems = new ArrayList<FilterItem>();
            for (int i = 0; i < tokens.size(); ++i) {
                String token = tokens.get(i);
                FilterItem filterItem = this.findFilterItem(token);
                filterItems.add(filterItem);
            }
            return new FilterItem(logicalOperator, filterItems);
        }
        expression = tokens.get(0);
        OperatorType operator = null;
        String leftSide = null;
        String rightSideCandidate = null;
        for (OperatorType operatorCandidate : operators = OperatorType.values()) {
            int operatorIndex = expression.indexOf(' ' + operatorCandidate.toSql() + ' ');
            if (operatorIndex <= 0) continue;
            operator = operatorCandidate;
            leftSide = expression.substring(0, operatorIndex).trim();
            rightSideCandidate = expression.substring(operatorIndex + operator.toSql().length() + 2).trim();
            break;
        }
        if (operator == null) {
            if (expression.endsWith(" IS NOT NULL")) {
                operator = OperatorType.DIFFERENT_FROM;
                leftSide = expression.substring(0, expression.lastIndexOf(" IS NOT NULL")).trim();
                rightSideCandidate = "NULL";
            } else if (expression.endsWith(" IS NULL")) {
                operator = OperatorType.EQUALS_TO;
                leftSide = expression.substring(0, expression.lastIndexOf(" IS NULL")).trim();
                rightSideCandidate = "NULL";
            }
        }
        String rightSide = rightSideCandidate;
        if (operator == null) {
            return new FilterItem(expression);
        }
        final SelectItem selectItem = this.findSelectItem(leftSide, false);
        if (selectItem == null) {
            return new FilterItem(expression);
        }
        if (operator == OperatorType.IN) {
            final ArrayList list = new ArrayList();
            new QueryPartParser(new QueryPartProcessor(){

                @Override
                public void parse(String delim, String itemToken) {
                    Object operand = Query.this.createOperand(itemToken, selectItem, false);
                    list.add(operand);
                }
            }, rightSide, ",").parse();
            operand = list;
        } else {
            operand = this.createOperand(rightSide, selectItem, true);
        }
        return new FilterItem(selectItem, operator, operand);
    }

    private Object createOperand(String token, SelectItem leftSelectItem, boolean searchSelectItems) {
        SelectItem selectItem;
        if (token.equals("NULL")) {
            return null;
        }
        if (token.startsWith("'") && token.endsWith("'")) {
            return token.substring(1, token.length() - 1);
        }
        if (searchSelectItems && (selectItem = this.findSelectItem(token, false)) != null) {
            return selectItem;
        }
        return NumberComparator.toNumber(token);
    }

    public Query where(SelectItem selectItem, OperatorType operatorType, Object operand) {
        return this.where(new FilterItem(selectItem, operatorType, operand));
    }

    public Query where(Column column, OperatorType operatorType, Object operand) {
        SelectItem selectItem = this._selectClause.getSelectItem(column);
        if (selectItem == null) {
            selectItem = new SelectItem(column);
        }
        return this.where(selectItem, operatorType, operand);
    }

    public Query having(FilterItem ... items) {
        this._havingClause.addItems(items);
        return this;
    }

    public Query having(Column column, OperatorType operatorType, Object operand) {
        SelectItem selectItem = this._selectClause.getSelectItem(column);
        if (selectItem == null) {
            selectItem = new SelectItem(column);
        }
        return this.having(new FilterItem(selectItem, operatorType, operand));
    }

    public Query having(String ... havingItemTokens) {
        for (String havingItemToken : havingItemTokens) {
            FilterItem filterItem = this.findFilterItem(havingItemToken);
            this.having(filterItem);
        }
        return this;
    }

    @Override
    public String toString() {
        return this.toSql();
    }

    public String toSql() {
        StringBuilder sb = new StringBuilder();
        sb.append(this._selectClause.toSql());
        sb.append(this._fromClause.toSql());
        sb.append(this._whereClause.toSql());
        sb.append(this._groupByClause.toSql());
        sb.append(this._havingClause.toSql());
        sb.append(this._orderByClause.toSql());
        return sb.toString();
    }

    public SelectClause getSelectClause() {
        return this._selectClause;
    }

    public FromClause getFromClause() {
        return this._fromClause;
    }

    public FilterClause getWhereClause() {
        return this._whereClause;
    }

    public GroupByClause getGroupByClause() {
        return this._groupByClause;
    }

    public FilterClause getHavingClause() {
        return this._havingClause;
    }

    public OrderByClause getOrderByClause() {
        return this._orderByClause;
    }

    public Query setMaxRows(Integer maxRows) {
        if (maxRows != null) {
            if (maxRows == 0) {
                throw new IllegalArgumentException("Max rows cannot be zero");
            }
            if (maxRows < 0) {
                throw new IllegalArgumentException("Max rows cannot be negative");
            }
        }
        this._maxRows = maxRows;
        return this;
    }

    public Integer getMaxRows() {
        return this._maxRows;
    }

    public Query setFirstRow(Integer firstRow) {
        if (firstRow != null && firstRow <= 0) {
            throw new IllegalArgumentException("First row cannot be negative or zero");
        }
        this._firstRow = firstRow;
        return this;
    }

    public Integer getFirstRow() {
        return this._firstRow;
    }

    @Override
    protected void decorateIdentity(List<Object> identifiers) {
        identifiers.add(this._maxRows);
        identifiers.add(this._selectClause);
        identifiers.add(this._fromClause);
        identifiers.add(this._whereClause);
        identifiers.add(this._groupByClause);
        identifiers.add(this._havingClause);
        identifiers.add(this._orderByClause);
    }

    public Query clone() {
        Query q = new Query();
        q.setMaxRows(this._maxRows);
        q.setFirstRow(this._firstRow);
        q.getSelectClause().setDistinct(this._selectClause.isDistinct());
        for (BaseObject item : this._fromClause.getItems()) {
            q.from(((FromItem)item).clone());
        }
        for (BaseObject item : this._selectClause.getItems()) {
            q.select(((SelectItem)item).clone());
        }
        for (BaseObject item : this._whereClause.getItems()) {
            q.where(((FilterItem)item).clone());
        }
        for (BaseObject item : this._groupByClause.getItems()) {
            q.groupBy(((GroupByItem)item).clone());
        }
        for (BaseObject item : this._havingClause.getItems()) {
            q.having(((FilterItem)item).clone());
        }
        for (BaseObject item : this._orderByClause.getItems()) {
            q.orderBy(((OrderByItem)item).clone());
        }
        return q;
    }
}

