/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.metamodel.query;

import java.util.List;
import org.eobjects.metamodel.query.FromItem;
import org.eobjects.metamodel.query.FunctionType;
import org.eobjects.metamodel.query.Query;
import org.eobjects.metamodel.query.QueryItem;
import org.eobjects.metamodel.schema.Column;
import org.eobjects.metamodel.schema.Schema;
import org.eobjects.metamodel.schema.Table;
import org.eobjects.metamodel.util.BaseObject;
import org.eobjects.metamodel.util.EqualsBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectItem
extends BaseObject
implements QueryItem,
Cloneable {
    private static final long serialVersionUID = 317475105509663973L;
    private static final Logger logger = LoggerFactory.getLogger(SelectItem.class);
    private final Column _column;
    private final FunctionType _function;
    private final String _expression;
    private final SelectItem _subQuerySelectItem;
    private final FromItem _fromItem;
    private boolean _functionApproximationAllowed;
    private Query _query;
    private String _alias;

    private SelectItem(Column column, FromItem fromItem, FunctionType function, String expression, SelectItem subQuerySelectItem, String alias, boolean functionApproximationAllowed) {
        this._column = column;
        this._fromItem = fromItem;
        this._function = function;
        this._expression = expression;
        this._subQuerySelectItem = subQuerySelectItem;
        this._alias = alias;
        this._functionApproximationAllowed = functionApproximationAllowed;
    }

    public static SelectItem getCountAllItem() {
        return new SelectItem(FunctionType.COUNT, "*", null);
    }

    public static boolean isCountAllItem(SelectItem item) {
        return item != null && item.getFunction() == FunctionType.COUNT && item.getExpression() == "*";
    }

    public SelectItem(Column column) {
        this(null, column);
    }

    public SelectItem(FunctionType function, Column column) {
        this(function, column, null);
    }

    public SelectItem(Column column, FromItem fromItem) {
        this(null, column, fromItem);
        if (fromItem != null) {
            Table fromItemTable = fromItem.getTable();
            Table columnTable = column.getTable();
            if (columnTable != null && !columnTable.equals(fromItemTable)) {
                throw new IllegalArgumentException("Column's table '" + columnTable.getName() + "' is not equal to referenced table: " + fromItemTable);
            }
        }
    }

    public SelectItem(FunctionType function, Column column, FromItem fromItem) {
        this(column, fromItem, function, null, null, null, false);
        if (column == null) {
            throw new IllegalArgumentException("column=null");
        }
    }

    public SelectItem(String expression, String alias) {
        this(null, expression, alias);
    }

    public SelectItem(FunctionType function, String expression, String alias) {
        this(null, null, function, expression, null, alias, false);
        if (expression == null) {
            throw new IllegalArgumentException("expression=null");
        }
    }

    public SelectItem(SelectItem subQuerySelectItem, FromItem subQueryFromItem) {
        this(null, subQueryFromItem, null, null, subQuerySelectItem, null, false);
        if (subQueryFromItem.getSubQuery() == null) {
            throw new IllegalArgumentException("Only sub-query based FromItems allowed.");
        }
        if (!subQuerySelectItem.getQuery().equals(subQueryFromItem.getSubQuery())) {
            throw new IllegalArgumentException("The SelectItem must exist in the sub-query");
        }
    }

    public String getAlias() {
        return this._alias;
    }

    public SelectItem setAlias(String alias) {
        this._alias = alias;
        return this;
    }

    public FunctionType getFunction() {
        return this._function;
    }

    public boolean isFunctionApproximationAllowed() {
        return this._functionApproximationAllowed;
    }

    public void setFunctionApproximationAllowed(boolean functionApproximationAllowed) {
        this._functionApproximationAllowed = functionApproximationAllowed;
    }

    public Column getColumn() {
        return this._column;
    }

    public String getExpression() {
        return this._expression;
    }

    @Override
    public SelectItem setQuery(Query query) {
        this._query = query;
        return this;
    }

    @Override
    public Query getQuery() {
        return this._query;
    }

    public SelectItem getSubQuerySelectItem() {
        return this._subQuerySelectItem;
    }

    @Deprecated
    public FromItem getSubQueryFromItem() {
        return this._fromItem;
    }

    public FromItem getFromItem() {
        return this._fromItem;
    }

    public String getSuperQueryAlias() {
        return this.getSuperQueryAlias(true);
    }

    public String getSuperQueryAlias(boolean includeQuotes) {
        if (this._alias != null) {
            return this._alias;
        }
        if (this._column != null) {
            if (includeQuotes) {
                return this._column.getQuotedName();
            }
            return this._column.getName();
        }
        logger.debug("Could not resolve a reasonable super-query alias for SelectItem: {}", (Object)this.toSql());
        return this.toStringNoAlias().toString();
    }

    public String getSameQueryAlias() {
        if (this._column != null) {
            StringBuilder sb = new StringBuilder();
            String columnPrefix = this.getToStringColumnPrefix(false);
            sb.append(columnPrefix);
            sb.append(this._column.getQuotedName());
            if (this._function != null) {
                sb.insert(0, (Object)((Object)this._function) + "(");
                sb.append(")");
            }
            return sb.toString();
        }
        String alias = this.getAlias();
        if (alias == null) {
            alias = this.toStringNoAlias().toString();
            logger.warn("Could not resolve a reasonable same-query alias for SelectItem: {}", (Object)this.toSql());
        }
        return alias;
    }

    @Override
    public String toSql() {
        return this.toSql(false);
    }

    public String toSql(boolean includeSchemaInColumnPath) {
        StringBuilder sb = this.toStringNoAlias(includeSchemaInColumnPath);
        if (this._alias != null) {
            sb.append(" AS ");
            sb.append(this._alias);
        }
        return sb.toString();
    }

    public StringBuilder toStringNoAlias() {
        return this.toStringNoAlias(false);
    }

    public StringBuilder toStringNoAlias(boolean includeSchemaInColumnPath) {
        StringBuilder sb = new StringBuilder();
        if (this._column != null) {
            sb.append(this.getToStringColumnPrefix(includeSchemaInColumnPath));
            sb.append(this._column.getQuotedName());
        }
        if (this._expression != null) {
            sb.append(this._expression);
        }
        if (this._fromItem != null && this._subQuerySelectItem != null) {
            if (this._fromItem.getAlias() != null) {
                sb.append(this._fromItem.getAlias() + '.');
            }
            sb.append(this._subQuerySelectItem.getSuperQueryAlias());
        }
        if (this._function != null) {
            sb.insert(0, (Object)((Object)this._function) + "(");
            sb.append(")");
        }
        return sb;
    }

    private String getToStringColumnPrefix(boolean includeSchemaInColumnPath) {
        StringBuilder sb = new StringBuilder();
        if (this._fromItem != null && this._fromItem.getAlias() != null) {
            sb.append(this._fromItem.getAlias());
            sb.append('.');
        } else {
            Table table = this._column.getTable();
            String tableLabel = this._query == null ? null : this._query.getFromClause().getAlias(table);
            if (table != null) {
                if (tableLabel == null) {
                    Schema schema;
                    tableLabel = table.getQuotedName();
                    if (includeSchemaInColumnPath && (schema = table.getSchema()) != null) {
                        tableLabel = schema.getQuotedName() + "." + tableLabel;
                    }
                }
                sb.append(tableLabel);
                sb.append('.');
            }
        }
        return sb.toString();
    }

    public boolean equalsIgnoreAlias(SelectItem that) {
        return this.equalsIgnoreAlias(that, false);
    }

    public boolean equalsIgnoreAlias(SelectItem that, boolean exactColumnCompare) {
        if (that == null) {
            return false;
        }
        if (that == this) {
            return true;
        }
        EqualsBuilder eb = new EqualsBuilder();
        if (exactColumnCompare) {
            eb.append(this._column == that._column);
            eb.append(this._fromItem, that._fromItem);
        } else {
            eb.append(this._column, that._column);
        }
        eb.append((Object)this._function, (Object)that._function);
        eb.append(this._functionApproximationAllowed, that._functionApproximationAllowed);
        eb.append(this._expression, that._expression);
        if (this._subQuerySelectItem != null) {
            eb.append(this._subQuerySelectItem.equalsIgnoreAlias(that._subQuerySelectItem));
        } else if (that._subQuerySelectItem != null) {
            eb.append(false);
        }
        return eb.isEquals();
    }

    @Override
    protected void decorateIdentity(List<Object> identifiers) {
        identifiers.add(this._expression);
        identifiers.add(this._alias);
        identifiers.add(this._column);
        identifiers.add((Object)this._function);
        identifiers.add(this._functionApproximationAllowed);
        identifiers.add(this._fromItem);
        identifiers.add(this._subQuerySelectItem);
    }

    protected SelectItem clone() {
        SelectItem subQuerySelectItem = this._subQuerySelectItem == null ? null : this._subQuerySelectItem.clone();
        FromItem fromItem = this._fromItem == null ? null : this._fromItem.clone();
        SelectItem s = new SelectItem(this._column, fromItem, this._function, this._expression, subQuerySelectItem, this._alias, this._functionApproximationAllowed);
        return s;
    }

    public SelectItem replaceFunction(FunctionType function) {
        return new SelectItem(this._column, this._fromItem, function, this._expression, this._subQuerySelectItem, this._alias, this._functionApproximationAllowed);
    }

    public boolean isReferenced(Column column) {
        if (column != null) {
            if (column.equals(this._column)) {
                return true;
            }
            if (this._subQuerySelectItem != null) {
                return this._subQuerySelectItem.isReferenced(column);
            }
        }
        return false;
    }

    @Override
    public String toString() {
        return this.toSql();
    }
}

