/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.metamodel.query.builder;

import java.util.List;
import org.eobjects.metamodel.DataContext;
import org.eobjects.metamodel.query.FromItem;
import org.eobjects.metamodel.query.JoinType;
import org.eobjects.metamodel.query.Query;
import org.eobjects.metamodel.query.SelectItem;
import org.eobjects.metamodel.query.builder.JoinFromBuilder;
import org.eobjects.metamodel.query.builder.SatisfiedFromBuilder;
import org.eobjects.metamodel.query.builder.SatisfiedFromBuilderCallback;
import org.eobjects.metamodel.schema.Column;
import org.eobjects.metamodel.schema.Table;

final class JoinFromBuilderImpl
extends SatisfiedFromBuilderCallback
implements JoinFromBuilder {
    private JoinType joinType;
    private FromItem leftItem;
    private FromItem rightItem;

    public JoinFromBuilderImpl(Query query, FromItem leftItem, Table rightTable, JoinType joinType, DataContext dataContext) {
        super(query, dataContext);
        this.joinType = joinType;
        this.leftItem = leftItem;
        this.rightItem = new FromItem(rightTable);
    }

    @Override
    public SatisfiedFromBuilder on(Column left, Column right) {
        if (left == null) {
            throw new IllegalArgumentException("left cannot be null");
        }
        if (right == null) {
            throw new IllegalArgumentException("right cannot be null");
        }
        this.getQuery().getFromClause().removeItem(this.leftItem);
        SelectItem[] leftOn = new SelectItem[]{new SelectItem(left)};
        SelectItem[] rightOn = new SelectItem[]{new SelectItem(right)};
        FromItem fromItem = new FromItem(this.joinType, this.leftItem, this.rightItem, leftOn, rightOn);
        this.getQuery().from(fromItem);
        return this;
    }

    @Override
    protected void decorateIdentity(List<Object> identifiers) {
        super.decorateIdentity(identifiers);
        identifiers.add((Object)this.joinType);
        identifiers.add(this.leftItem);
        identifiers.add(this.rightItem);
    }
}

