/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.metamodel.query.builder;

import java.util.List;
import org.eobjects.metamodel.DataContext;
import org.eobjects.metamodel.query.FunctionType;
import org.eobjects.metamodel.query.Query;
import org.eobjects.metamodel.query.builder.ColumnSelectBuilder;
import org.eobjects.metamodel.query.builder.ColumnSelectBuilderImpl;
import org.eobjects.metamodel.query.builder.CountSelectBuilder;
import org.eobjects.metamodel.query.builder.CountSelectBuilderImpl;
import org.eobjects.metamodel.query.builder.FunctionSelectBuilder;
import org.eobjects.metamodel.query.builder.FunctionSelectBuilderImpl;
import org.eobjects.metamodel.query.builder.GroupedQueryBuilderImpl;
import org.eobjects.metamodel.query.builder.SatisfiedFromBuilder;
import org.eobjects.metamodel.query.builder.SatisfiedSelectBuilder;
import org.eobjects.metamodel.query.builder.SatisfiedSelectBuilderImpl;
import org.eobjects.metamodel.query.builder.TableFromBuilder;
import org.eobjects.metamodel.query.builder.TableFromBuilderImpl;
import org.eobjects.metamodel.schema.Column;
import org.eobjects.metamodel.schema.Schema;
import org.eobjects.metamodel.schema.Table;
import org.eobjects.metamodel.util.BaseObject;

abstract class SatisfiedFromBuilderCallback
extends BaseObject
implements SatisfiedFromBuilder {
    private Query query;
    private DataContext dataContext;

    public SatisfiedFromBuilderCallback(Query query, DataContext dataContext) {
        this.query = query;
        this.dataContext = dataContext;
    }

    protected Query getQuery() {
        return this.query;
    }

    protected DataContext getDataContext() {
        return this.dataContext;
    }

    @Override
    public TableFromBuilder and(Table table) {
        if (table == null) {
            throw new IllegalArgumentException("table cannot be null");
        }
        return new TableFromBuilderImpl(table, this.query, this.dataContext);
    }

    @Override
    public ColumnSelectBuilder<?> select(Column column) {
        if (column == null) {
            throw new IllegalArgumentException("column cannot be null");
        }
        GroupedQueryBuilderImpl queryBuilder = new GroupedQueryBuilderImpl(this.dataContext, this.query);
        return new ColumnSelectBuilderImpl(column, this.query, queryBuilder);
    }

    @Override
    public FunctionSelectBuilder<?> select(FunctionType functionType, Column column) {
        if (functionType == null) {
            throw new IllegalArgumentException("functionType cannot be null");
        }
        if (column == null) {
            throw new IllegalArgumentException("column cannot be null");
        }
        GroupedQueryBuilderImpl queryBuilder = new GroupedQueryBuilderImpl(this.dataContext, this.query);
        return new FunctionSelectBuilderImpl(functionType, column, this.query, queryBuilder);
    }

    @Override
    public CountSelectBuilder<?> selectCount() {
        GroupedQueryBuilderImpl queryBuilder = new GroupedQueryBuilderImpl(this.dataContext, this.query);
        return new CountSelectBuilderImpl(this.query, queryBuilder);
    }

    @Override
    public TableFromBuilder and(String schemaName, String tableName) {
        if (schemaName == null) {
            throw new IllegalArgumentException("schemaName cannot be null");
        }
        if (tableName == null) {
            throw new IllegalArgumentException("tableName cannot be null");
        }
        Schema schema = this.dataContext.getSchemaByName(schemaName);
        if (schema == null) {
            schema = this.dataContext.getDefaultSchema();
        }
        return this.and(schema, tableName);
    }

    private TableFromBuilder and(Schema schema, String tableName) {
        Table table = schema.getTableByName(tableName);
        return this.and(table);
    }

    @Override
    public TableFromBuilder and(String tableName) {
        if (tableName == null) {
            throw new IllegalArgumentException("tableName cannot be null");
        }
        return this.and(this.dataContext.getDefaultSchema(), tableName);
    }

    @Override
    public SatisfiedSelectBuilder<?> select(Column ... columns) {
        if (columns == null) {
            throw new IllegalArgumentException("columns cannot be null");
        }
        this.query.select(columns);
        GroupedQueryBuilderImpl queryBuilder = new GroupedQueryBuilderImpl(this.dataContext, this.query);
        return new SatisfiedSelectBuilderImpl(queryBuilder);
    }

    @Override
    public SatisfiedSelectBuilder<?> select(String ... columnNames) {
        if (columnNames == null) {
            throw new IllegalArgumentException("columnNames cannot be null");
        }
        for (String columnName : columnNames) {
            this.select(columnName);
        }
        GroupedQueryBuilderImpl queryBuilder = new GroupedQueryBuilderImpl(this.dataContext, this.query);
        return new SatisfiedSelectBuilderImpl(queryBuilder);
    }

    @Override
    public ColumnSelectBuilder<?> select(String columnName) {
        if (columnName == null) {
            throw new IllegalArgumentException("columnName cannot be null");
        }
        GroupedQueryBuilderImpl queryBuilder = new GroupedQueryBuilderImpl(this.dataContext, this.query);
        Column column = queryBuilder.findColumn(columnName);
        return this.select(column);
    }

    @Override
    protected void decorateIdentity(List<Object> identifiers) {
        identifiers.add(this.query);
    }
}

