/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.metamodel.query.builder;

import java.util.ArrayList;
import java.util.List;
import org.eobjects.metamodel.query.FilterItem;
import org.eobjects.metamodel.query.Query;
import org.eobjects.metamodel.query.QueryItem;
import org.eobjects.metamodel.query.SelectItem;
import org.eobjects.metamodel.query.builder.AbstractQueryFilterBuilder;
import org.eobjects.metamodel.query.builder.GroupedQueryBuilder;
import org.eobjects.metamodel.query.builder.SatisfiedWhereBuilder;
import org.eobjects.metamodel.query.builder.WhereBuilder;
import org.eobjects.metamodel.schema.Column;

final class WhereBuilderImpl
extends AbstractQueryFilterBuilder<SatisfiedWhereBuilder<GroupedQueryBuilder>>
implements WhereBuilder<GroupedQueryBuilder>,
SatisfiedWhereBuilder<GroupedQueryBuilder> {
    private final Query _query;
    private final List<FilterItem> _orFilters;
    private FilterItem _parentOrFilter;

    public WhereBuilderImpl(Column column, Query query, GroupedQueryBuilder queryBuilder) {
        super(new SelectItem(column), queryBuilder);
        this._query = query;
        this._orFilters = new ArrayList<FilterItem>();
    }

    public WhereBuilderImpl(Column column, Query query, FilterItem parentOrFilter, List<FilterItem> orFilters, GroupedQueryBuilder queryBuilder) {
        super(new SelectItem(column), queryBuilder);
        this._query = query;
        this._parentOrFilter = parentOrFilter;
        this._orFilters = orFilters;
    }

    @Override
    protected SatisfiedWhereBuilder<GroupedQueryBuilder> applyFilter(FilterItem filter) {
        if (this._parentOrFilter == null) {
            this._query.where(filter);
        } else if (this._parentOrFilter.getChildItemCount() == 1) {
            this._query.getWhereClause().removeItem((QueryItem)this._orFilters.get(0));
            this._query.getWhereClause().addItem(this._parentOrFilter);
        }
        this._orFilters.add(filter);
        return this;
    }

    @Override
    public WhereBuilder<GroupedQueryBuilder> or(String columnName) {
        Column column = this.findColumn(columnName);
        return this.or(column);
    }

    @Override
    public WhereBuilder<GroupedQueryBuilder> or(Column column) {
        if (this._parentOrFilter == null) {
            this._parentOrFilter = new FilterItem(this._orFilters);
        }
        return new WhereBuilderImpl(column, this._query, this._parentOrFilter, this._orFilters, this.getQueryBuilder());
    }

    @Override
    public WhereBuilder<GroupedQueryBuilder> and(String columnName) {
        Column column = this.findColumn(columnName);
        return this.and(column);
    }

    @Override
    public WhereBuilder<GroupedQueryBuilder> and(Column column) {
        return this.getQueryBuilder().where(column);
    }
}

