/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.metamodel.query.parser;

import org.eobjects.metamodel.DataContext;
import org.eobjects.metamodel.MetaModelException;
import org.eobjects.metamodel.query.FromItem;
import org.eobjects.metamodel.query.JoinType;
import org.eobjects.metamodel.query.Query;
import org.eobjects.metamodel.query.SelectItem;
import org.eobjects.metamodel.query.parser.QueryPartProcessor;
import org.eobjects.metamodel.query.parser.SelectItemParser;
import org.eobjects.metamodel.schema.Table;

final class FromItemParser
implements QueryPartProcessor {
    private final Query _query;
    private final DataContext _dataContext;

    public FromItemParser(DataContext dataContext, Query query) {
        this._dataContext = dataContext;
        this._query = query;
    }

    @Override
    public void parse(String delim, String itemToken) {
        if (itemToken.indexOf(40) != -1) {
            throw new MetaModelException("Not capable of parsing FROM token: " + itemToken);
        }
        FromItem fromItem = itemToken.indexOf(" JOIN ") != -1 ? this.parseJoinItem(itemToken) : this.parseTableItem(itemToken);
        this._query.from(fromItem);
    }

    private FromItem parseTableItem(String itemToken) {
        String alias;
        String[] tokens = itemToken.split(" ");
        if (tokens.length == 2) {
            alias = tokens[1];
        } else if (tokens.length == 1) {
            alias = null;
        } else {
            throw new MetaModelException("Not capable of parsing FROM token: " + itemToken);
        }
        Table table = this._dataContext.getTableByQualifiedLabel(tokens[0]);
        if (table == null) {
            throw new MetaModelException("Not capable of parsing FROM token: " + itemToken);
        }
        FromItem result = new FromItem(table);
        result.setAlias(alias);
        result.setQuery(this._query);
        return result;
    }

    private FromItem parseJoinItem(String itemToken) {
        int indexOfJoin = itemToken.indexOf(" JOIN ");
        String firstPart = itemToken.substring(0, indexOfJoin).trim();
        String secondPart = itemToken.substring(indexOfJoin + " JOIN ".length()).trim();
        int indexOfJoinType = firstPart.lastIndexOf(" ");
        String joinTypeString = firstPart.substring(indexOfJoinType).trim().toUpperCase();
        JoinType joinType = JoinType.valueOf(joinTypeString);
        String firstTableToken = firstPart.substring(0, indexOfJoinType).trim();
        int indexOfOn = secondPart.indexOf(" ON ");
        String secondTableToken = secondPart.substring(0, indexOfOn).trim();
        FromItem leftSide = this.parseTableItem(firstTableToken);
        FromItem rightSide = this.parseTableItem(secondTableToken);
        String[] onClauses = secondPart.substring(indexOfOn + " ON ".length()).split(" AND ");
        SelectItem[] leftOn = new SelectItem[onClauses.length];
        SelectItem[] rightOn = new SelectItem[onClauses.length];
        for (int i = 0; i < onClauses.length; ++i) {
            String onClause = onClauses[i];
            int indexOfEquals = onClause.indexOf("=");
            String leftPart = onClause.substring(0, indexOfEquals).trim();
            String rightPart = onClause.substring(indexOfEquals + 1).trim();
            leftOn[i] = this.findSelectItem(leftPart, leftSide, rightSide);
            rightOn[i] = this.findSelectItem(rightPart, leftSide, rightSide);
        }
        FromItem result = new FromItem(joinType, leftSide, rightSide, leftOn, rightOn);
        result.setQuery(this._query);
        return result;
    }

    private SelectItem findSelectItem(String token, FromItem leftSide, FromItem rightSide) {
        SelectItemParser selectItemParser = new SelectItemParser(this._query, false);
        SelectItem result = selectItemParser.findSelectItem(token);
        if (result == null) {
            Query temporaryQuery = new Query().from(leftSide, rightSide);
            selectItemParser = new SelectItemParser(temporaryQuery, false);
            result = selectItemParser.findSelectItem(token);
            if (result == null) {
                throw new MetaModelException("Not capable of parsing ON token: " + token);
            }
            leftSide.setQuery(this._query);
            rightSide.setQuery(this._query);
            result.setQuery(this._query);
        }
        return result;
    }
}

