/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.metamodel.query.parser;

import org.eobjects.metamodel.DataContext;
import org.eobjects.metamodel.MetaModelException;
import org.eobjects.metamodel.query.Query;
import org.eobjects.metamodel.query.parser.FromItemParser;
import org.eobjects.metamodel.query.parser.GroupByItemParser;
import org.eobjects.metamodel.query.parser.HavingItemParser;
import org.eobjects.metamodel.query.parser.OrderByItemParser;
import org.eobjects.metamodel.query.parser.QueryPartParser;
import org.eobjects.metamodel.query.parser.SelectItemParser;
import org.eobjects.metamodel.query.parser.WhereItemParser;

public class QueryParser {
    private final DataContext _dataContext;
    private final String _queryString;

    public QueryParser(DataContext dataContext, String queryString) {
        if (dataContext == null) {
            throw new IllegalArgumentException("DataContext cannot be null");
        }
        if (queryString == null) {
            throw new IllegalArgumentException("Query string cannot be null");
        }
        this._dataContext = dataContext;
        this._queryString = queryString;
    }

    public Query parse() {
        String offsetClause;
        String limitClause;
        String orderByClause;
        String havingClause;
        String groupByClause;
        String whereClause;
        Query query = new Query();
        int[] selectIndices = this.indexesOf("SELECT ", null);
        int[] fromIndices = this.indexesOf(" FROM ", selectIndices);
        int[] whereIndices = this.indexesOf(" WHERE ", fromIndices);
        int[] groupByIndices = this.indexesOf(" GROUP BY ", whereIndices);
        int[] havingIndices = this.indexesOf(" HAVING ", groupByIndices);
        int[] orderByIndices = this.indexesOf(" ORDER BY", havingIndices);
        int[] limitIndices = this.indexesOf(" LIMIT ", orderByIndices);
        int[] offsetIndices = this.indexesOf(" OFFSET ", limitIndices);
        if (selectIndices == null) {
            throw new MetaModelException("SELECT not found in query: " + this._queryString);
        }
        if (fromIndices == null) {
            throw new MetaModelException("FROM not found in query: " + this._queryString);
        }
        String fromClause = this.getSubstring(this.getLastEndIndex(new int[][]{fromIndices}), this.getNextStartIndex(whereIndices, groupByIndices, havingIndices, orderByIndices, limitIndices, offsetIndices));
        this.parseFromClause(query, fromClause);
        String selectClause = this.getSubstring(this.getLastEndIndex(new int[][]{selectIndices}), fromIndices[0]);
        this.parseSelectClause(query, selectClause);
        if (whereIndices != null && (whereClause = this.getSubstring(this.getLastEndIndex(new int[][]{whereIndices}), this.getNextStartIndex(groupByIndices, havingIndices, orderByIndices, limitIndices, offsetIndices))) != null) {
            this.parseWhereClause(query, whereClause);
        }
        if (groupByIndices != null && (groupByClause = this.getSubstring(this.getLastEndIndex(groupByIndices, whereIndices), this.getNextStartIndex(havingIndices, orderByIndices, limitIndices, offsetIndices))) != null) {
            this.parseGroupByClause(query, groupByClause);
        }
        if (havingIndices != null && (havingClause = this.getSubstring(this.getLastEndIndex(havingIndices, groupByIndices, whereIndices, fromIndices, selectIndices), this.getNextStartIndex(orderByIndices, limitIndices, offsetIndices))) != null) {
            this.parseHavingClause(query, havingClause);
        }
        if (orderByIndices != null && (orderByClause = this.getSubstring(this.getLastEndIndex(orderByIndices, havingIndices, groupByIndices, whereIndices, fromIndices, selectIndices), this.getNextStartIndex(limitIndices, offsetIndices))) != null) {
            this.parseOrderByClause(query, orderByClause);
        }
        if (limitIndices != null && (limitClause = this.getSubstring(this.getLastEndIndex(limitIndices, orderByIndices, havingIndices, groupByIndices, whereIndices, fromIndices, selectIndices), this.getNextStartIndex(new int[][]{offsetIndices}))) != null) {
            this.parseLimitClause(query, limitClause);
        }
        if (offsetIndices != null && (offsetClause = this.getSubstring(this.getLastEndIndex(offsetIndices, limitIndices, orderByIndices, havingIndices, groupByIndices, whereIndices, fromIndices, selectIndices), this.getNextStartIndex(new int[0][]))) != null) {
            this.parseOffsetClause(query, offsetClause);
        }
        return query;
    }

    private void parseFromClause(Query query, String fromClause) {
        QueryPartParser clauseParser = new QueryPartParser(new FromItemParser(this._dataContext, query), fromClause, ",");
        clauseParser.parse();
    }

    private void parseSelectClause(Query query, String selectClause) {
        QueryPartParser clauseParser = new QueryPartParser(new SelectItemParser(query, false), selectClause, ",");
        clauseParser.parse();
    }

    private void parseWhereClause(Query query, String whereClause) {
        QueryPartParser clauseParser = new QueryPartParser(new WhereItemParser(query), whereClause, " AND ");
        clauseParser.parse();
    }

    private void parseGroupByClause(Query query, String groupByClause) {
        QueryPartParser clauseParser = new QueryPartParser(new GroupByItemParser(query), groupByClause, ",");
        clauseParser.parse();
    }

    private void parseHavingClause(Query query, String havingClause) {
        QueryPartParser clauseParser = new QueryPartParser(new HavingItemParser(query), havingClause, " AND ");
        clauseParser.parse();
    }

    private void parseOrderByClause(Query query, String orderByClause) {
        QueryPartParser clauseParser = new QueryPartParser(new OrderByItemParser(query), orderByClause, ",");
        clauseParser.parse();
    }

    private void parseLimitClause(Query query, String limitClause) {
        if (!(limitClause = limitClause.trim()).isEmpty()) {
            int limit = Integer.parseInt(limitClause);
            query.setMaxRows(limit);
        }
    }

    private void parseOffsetClause(Query query, String offsetClause) {
        if (!(offsetClause = offsetClause.trim()).isEmpty()) {
            int offset = Integer.parseInt(offsetClause);
            query.setFirstRow(offset);
        }
    }

    private String getSubstring(Integer from, int to) {
        if (from == null) {
            return null;
        }
        if (from == to) {
            return null;
        }
        return this._queryString.substring(from, to);
    }

    private int getNextStartIndex(int[] ... indicesArray) {
        for (int[] indices : indicesArray) {
            if (indices == null) continue;
            return indices[0];
        }
        return this._queryString.length();
    }

    private Integer getLastEndIndex(int[] ... indicesArray) {
        for (int[] indices : indicesArray) {
            if (indices == null) continue;
            return indices[1];
        }
        return null;
    }

    protected int[] indexesOf(String string, int[] previousIndices) {
        int startIndex = previousIndices == null ? this._queryString.indexOf(string) : this._queryString.indexOf(string, previousIndices[1]);
        if (startIndex == -1) {
            return null;
        }
        int endIndex = startIndex + string.length();
        return new int[]{startIndex, endIndex};
    }
}

