/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.metamodel.query.parser;

import org.eobjects.metamodel.MetaModelException;
import org.eobjects.metamodel.query.FromItem;
import org.eobjects.metamodel.query.FunctionType;
import org.eobjects.metamodel.query.Query;
import org.eobjects.metamodel.query.SelectItem;
import org.eobjects.metamodel.query.parser.QueryPartProcessor;
import org.eobjects.metamodel.schema.Column;

public final class SelectItemParser
implements QueryPartProcessor {
    private final Query _query;
    private final boolean _allowExpressionBasedSelectItems;

    public SelectItemParser(Query query, boolean allowExpressionBasedSelectItems) {
        this._query = query;
        this._allowExpressionBasedSelectItems = allowExpressionBasedSelectItems;
    }

    @Override
    public void parse(String delim, String itemToken) throws MetaModelException {
        SelectItem selectItem = this.findSelectItem(itemToken);
        if (selectItem == null) {
            throw new MetaModelException("Not capable of parsing SELECT token: " + itemToken);
        }
        this._query.select(selectItem);
    }

    public SelectItem findSelectItem(String expression) {
        Column column;
        FromItem fromItem;
        String columnName;
        int lastIndexOfDot;
        FunctionType function;
        if ("COUNT(*)".equalsIgnoreCase(expression)) {
            return SelectItem.getCountAllItem();
        }
        int startParenthesis = expression.indexOf(40);
        if (startParenthesis > 0 && expression.endsWith(")")) {
            String functionName = expression.substring(0, startParenthesis);
            function = FunctionType.get(functionName);
            if (function != null) {
                expression = expression.substring(startParenthesis + 1, expression.length() - 1).trim();
                if (function == FunctionType.COUNT && "*".equals(expression)) {
                    return SelectItem.getCountAllItem();
                }
            }
        } else {
            function = null;
        }
        if ((lastIndexOfDot = expression.lastIndexOf(".")) != -1) {
            String prefix = expression.substring(0, lastIndexOfDot);
            columnName = expression.substring(lastIndexOfDot + 1);
            fromItem = this._query.getFromClause().getItemByReference(prefix);
        } else if (this._query.getFromClause().getItemCount() == 1) {
            fromItem = (FromItem)this._query.getFromClause().getItem(0);
            columnName = expression;
        } else {
            fromItem = null;
            columnName = null;
        }
        if (fromItem != null && fromItem.getTable() != null && (column = fromItem.getTable().getColumnByName(columnName)) != null) {
            SelectItem selectItem = new SelectItem(function, column, fromItem);
            return selectItem;
        }
        if (this._allowExpressionBasedSelectItems) {
            return new SelectItem(function, expression, null);
        }
        return null;
    }
}

