/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.metamodel.schema;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.eobjects.metamodel.schema.Relationship;
import org.eobjects.metamodel.schema.Schema;
import org.eobjects.metamodel.schema.Table;
import org.eobjects.metamodel.schema.TableType;
import org.eobjects.metamodel.util.Action;
import org.eobjects.metamodel.util.BaseObject;
import org.eobjects.metamodel.util.CollectionUtils;
import org.eobjects.metamodel.util.HasNameMapper;
import org.eobjects.metamodel.util.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSchema
extends BaseObject
implements Schema {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(AbstractSchema.class);

    @Override
    public final String getQuotedName() {
        String quote = this.getQuote();
        if (quote == null) {
            return this.getName();
        }
        return quote + this.getName() + quote;
    }

    @Override
    public Relationship[] getRelationships() {
        final LinkedHashSet result = new LinkedHashSet();
        CollectionUtils.forEach(this.getTables(), new Action<Table>(){

            @Override
            public void run(Table table) {
                Relationship[] relations = table.getRelationships();
                for (int i = 0; i < relations.length; ++i) {
                    Relationship relation = relations[i];
                    result.add(relation);
                }
            }
        });
        return result.toArray(new Relationship[result.size()]);
    }

    @Override
    public Table getTable(int index) throws IndexOutOfBoundsException {
        Table[] tables = this.getTables();
        return tables[index];
    }

    @Override
    public final String getQualifiedLabel() {
        return this.getName();
    }

    @Override
    public final int getTableCount(TableType type) {
        return this.getTables(type).length;
    }

    @Override
    public final int getRelationshipCount() {
        return this.getRelationships().length;
    }

    @Override
    public final int getTableCount() {
        return this.getTables().length;
    }

    @Override
    public final Table[] getTables(final TableType type) {
        return CollectionUtils.filter(this.getTables(), new Predicate<Table>(){

            @Override
            public Boolean eval(Table table) {
                return table.getType() == type;
            }
        }).toArray(new Table[0]);
    }

    @Override
    public final Table getTableByName(String tableName) {
        if (tableName == null) {
            return null;
        }
        ArrayList<Table> foundTables = new ArrayList<Table>(1);
        for (Table table : this.getTables()) {
            if (!tableName.equalsIgnoreCase(table.getName())) continue;
            foundTables.add(table);
        }
        int numTables = foundTables.size();
        if (logger.isDebugEnabled()) {
            logger.debug("Found {} tables(s) matching '{}': {}", new Object[]{numTables, tableName, foundTables});
        }
        if (numTables == 0) {
            return null;
        }
        if (numTables == 1) {
            return (Table)foundTables.get(0);
        }
        for (Table table : foundTables) {
            if (!tableName.equals(table.getName())) continue;
            return table;
        }
        return (Table)foundTables.get(0);
    }

    @Override
    public final String[] getTableNames() {
        Table[] tables = this.getTables();
        return CollectionUtils.map(tables, new HasNameMapper()).toArray(new String[tables.length]);
    }

    @Override
    public final String toString() {
        return "Schema[name=" + this.getName() + "]";
    }

    @Override
    protected final boolean classEquals(BaseObject obj) {
        return obj instanceof Schema;
    }

    @Override
    protected final void decorateIdentity(List<Object> identifiers) {
        identifiers.add(this.getName());
        identifiers.add(this.getQuote());
        try {
            Table[] tables = this.getTables();
            identifiers.add(tables.length);
        }
        catch (Exception e) {
            logger.warn("Failed to fetch tables", (Throwable)e);
            identifiers.add(-1);
        }
    }

    @Override
    public final int compareTo(Schema that) {
        int diff = this.getQualifiedLabel().compareTo(that.getQualifiedLabel());
        if (diff == 0) {
            diff = this.toString().compareTo(that.toString());
        }
        return diff;
    }
}

