/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.metamodel.schema;

import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.eobjects.metamodel.schema.JdbcTypes;
import org.eobjects.metamodel.schema.SuperColumnType;
import org.eobjects.metamodel.util.NumberComparator;
import org.eobjects.metamodel.util.ObjectComparator;
import org.eobjects.metamodel.util.TimeComparator;
import org.eobjects.metamodel.util.ToStringComparator;

public enum ColumnType {
    CHAR(SuperColumnType.LITERAL_TYPE),
    VARCHAR(SuperColumnType.LITERAL_TYPE),
    LONGVARCHAR(SuperColumnType.LITERAL_TYPE),
    CLOB(SuperColumnType.LITERAL_TYPE),
    NCHAR(SuperColumnType.LITERAL_TYPE),
    NVARCHAR(SuperColumnType.LITERAL_TYPE),
    LONGNVARCHAR(SuperColumnType.LITERAL_TYPE),
    NCLOB(SuperColumnType.LITERAL_TYPE),
    TINYINT(SuperColumnType.NUMBER_TYPE),
    SMALLINT(SuperColumnType.NUMBER_TYPE),
    INTEGER(SuperColumnType.NUMBER_TYPE),
    BIGINT(SuperColumnType.NUMBER_TYPE),
    FLOAT(SuperColumnType.NUMBER_TYPE),
    REAL(SuperColumnType.NUMBER_TYPE),
    DOUBLE(SuperColumnType.NUMBER_TYPE),
    NUMERIC(SuperColumnType.NUMBER_TYPE),
    DECIMAL(SuperColumnType.NUMBER_TYPE),
    DATE(SuperColumnType.TIME_TYPE),
    TIME(SuperColumnType.TIME_TYPE),
    TIMESTAMP(SuperColumnType.TIME_TYPE),
    BIT(SuperColumnType.BOOLEAN_TYPE),
    BOOLEAN(SuperColumnType.BOOLEAN_TYPE),
    BINARY(SuperColumnType.BINARY_TYPE),
    VARBINARY(SuperColumnType.BINARY_TYPE),
    LONGVARBINARY(SuperColumnType.BINARY_TYPE),
    BLOB(SuperColumnType.BINARY_TYPE),
    NULL(SuperColumnType.OTHER_TYPE),
    OTHER(SuperColumnType.OTHER_TYPE),
    JAVA_OBJECT(SuperColumnType.OTHER_TYPE),
    DISTINCT(SuperColumnType.OTHER_TYPE),
    STRUCT(SuperColumnType.OTHER_TYPE),
    ARRAY(SuperColumnType.OTHER_TYPE),
    REF(SuperColumnType.OTHER_TYPE),
    DATALINK(SuperColumnType.OTHER_TYPE),
    ROWID(SuperColumnType.OTHER_TYPE),
    SQLXML(SuperColumnType.OTHER_TYPE),
    LIST(SuperColumnType.OTHER_TYPE),
    MAP(SuperColumnType.OTHER_TYPE);

    private SuperColumnType _superType;

    private ColumnType(SuperColumnType superType) {
        if (superType == null) {
            throw new IllegalArgumentException("SuperColumnType cannot be null");
        }
        this._superType = superType;
    }

    public Comparator<Object> getComparator() {
        if (this.isTimeBased()) {
            return TimeComparator.getComparator();
        }
        if (this.isNumber()) {
            return NumberComparator.getComparator();
        }
        if (this.isLiteral()) {
            return ToStringComparator.getComparator();
        }
        return ObjectComparator.getComparator();
    }

    public boolean isBoolean() {
        return this._superType == SuperColumnType.BOOLEAN_TYPE;
    }

    public boolean isBinary() {
        return this._superType == SuperColumnType.BINARY_TYPE;
    }

    public boolean isNumber() {
        return this._superType == SuperColumnType.NUMBER_TYPE;
    }

    public boolean isTimeBased() {
        return this._superType == SuperColumnType.TIME_TYPE;
    }

    public boolean isLiteral() {
        return this._superType == SuperColumnType.LITERAL_TYPE;
    }

    public boolean isLargeObject() {
        switch (this) {
            case BLOB: 
            case CLOB: 
            case NCLOB: {
                return true;
            }
        }
        return false;
    }

    public Class<?> getJavaEquivalentClass() {
        switch (this) {
            case TINYINT: 
            case SMALLINT: {
                return Short.class;
            }
            case INTEGER: {
                return Integer.class;
            }
            case BIGINT: {
                return BigInteger.class;
            }
            case DECIMAL: 
            case NUMERIC: 
            case FLOAT: 
            case REAL: 
            case DOUBLE: {
                return Double.class;
            }
            case DATE: 
            case TIME: 
            case TIMESTAMP: {
                return java.util.Date.class;
            }
            case CHAR: {
                return Character.class;
            }
            case BLOB: {
                return Blob.class;
            }
            case CLOB: 
            case NCLOB: {
                return Clob.class;
            }
            case MAP: {
                return Map.class;
            }
            case LIST: {
                return List.class;
            }
        }
        return this._superType.getJavaEquivalentClass();
    }

    public SuperColumnType getSuperType() {
        return this._superType;
    }

    public static ColumnType convertColumnType(int jdbcType) {
        try {
            Field[] fields = JdbcTypes.class.getFields();
            for (int i = 0; i < fields.length; ++i) {
                Field field = fields[i];
                int value = field.getInt(null);
                if (value != jdbcType) continue;
                String fieldName = field.getName();
                ColumnType[] enumConstants = (ColumnType[])ColumnType.class.getEnumConstants();
                for (int j = 0; j < enumConstants.length; ++j) {
                    ColumnType columnType = enumConstants[j];
                    if (!fieldName.equals(columnType.toString())) continue;
                    return columnType;
                }
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not access fields in JdbcTypes", e);
        }
        return OTHER;
    }

    public static ColumnType convertColumnType(Class<?> cls) {
        if (cls == null) {
            throw new IllegalArgumentException("Class cannot be null");
        }
        ColumnType type = cls == String.class ? VARCHAR : (cls == Boolean.class || cls == Boolean.TYPE ? BOOLEAN : (cls == Character.class || cls == Character.TYPE || cls == Character[].class || cls == char[].class ? CHAR : (cls == Byte.class || cls == Byte.TYPE ? TINYINT : (cls == Short.class || cls == Short.TYPE ? SMALLINT : (cls == Integer.class || cls == Integer.TYPE ? INTEGER : (cls == Long.class || cls == Long.TYPE || cls == BigInteger.class ? BIGINT : (cls == Float.class || cls == Float.TYPE ? FLOAT : (cls == Double.class || cls == Double.TYPE ? DOUBLE : (cls == BigDecimal.class ? DECIMAL : (Map.class.isAssignableFrom(cls) ? MAP : (List.class.isAssignableFrom(cls) ? LIST : (cls == Date.class ? DATE : (cls == Timestamp.class ? TIMESTAMP : (cls == Time.class ? TIME : (java.util.Date.class.isAssignableFrom(cls) ? TIMESTAMP : OTHER)))))))))))))));
        return type;
    }
}

