/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.metamodel.schema;

import java.util.Collection;
import java.util.HashSet;
import org.eobjects.metamodel.schema.AbstractSchema;
import org.eobjects.metamodel.schema.Relationship;
import org.eobjects.metamodel.schema.Schema;
import org.eobjects.metamodel.schema.Table;
import org.eobjects.metamodel.util.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompositeSchema
extends AbstractSchema {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(CompositeSchema.class);
    private final String name;
    private final Collection<? extends Schema> delegates;

    public CompositeSchema(String name, Collection<? extends Schema> delegates) {
        this.name = name;
        this.delegates = delegates;
        if (logger.isWarnEnabled()) {
            HashSet<String> names = new HashSet<String>();
            for (Table table : this.getTables()) {
                if (names.contains(table.getName())) {
                    logger.warn("Name-clash detected for Table {}.", (Object)table.getName());
                    logger.warn("getTableByName(\"{}\") will return just the first table.", (Object)table.getName());
                    continue;
                }
                names.add(table.getName());
            }
            if (!names.isEmpty()) {
                logger.warn("The following table names clashes in composite schema: " + names);
            }
        }
    }

    @Override
    public Relationship[] getRelationships() {
        Relationship[] result = new Relationship[]{};
        for (Schema schema : this.delegates) {
            result = CollectionUtils.array(result, schema.getRelationships());
        }
        return result;
    }

    @Override
    public Table[] getTables() {
        Table[] result = new Table[]{};
        for (Schema schema : this.delegates) {
            result = CollectionUtils.array(result, schema.getTables());
        }
        return result;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getQuote() {
        return null;
    }
}

