/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.metamodel.util;

import java.lang.reflect.Array;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EqualsBuilder {
    private static final Logger logger = LoggerFactory.getLogger(EqualsBuilder.class);
    private boolean equals = true;

    public EqualsBuilder append(boolean b) {
        logger.debug("append({})", (Object)b);
        if (this.equals) {
            this.equals = b;
        }
        return this;
    }

    public EqualsBuilder append(Object o1, Object o2) {
        if (this.equals) {
            this.equals = EqualsBuilder.equals(o1, o2);
        }
        return this;
    }

    public static boolean equals(Object obj1, Object obj2) {
        if (obj1 == obj2) {
            return true;
        }
        if (obj1 == null || obj2 == null) {
            return false;
        }
        Class<?> class1 = obj1.getClass();
        Class<?> class2 = obj2.getClass();
        if (class1.isArray()) {
            int length2;
            Class<?> componentType2;
            if (!class2.isArray()) {
                return false;
            }
            Class<?> componentType1 = class1.getComponentType();
            if (!componentType1.equals(componentType2 = class2.getComponentType())) {
                return false;
            }
            int length1 = Array.getLength(obj1);
            if (length1 != (length2 = Array.getLength(obj2))) {
                return false;
            }
            for (int i = 0; i < length1; ++i) {
                Object elem2;
                Object elem1 = Array.get(obj1, i);
                if (EqualsBuilder.equals(elem1, elem2 = Array.get(obj2, i))) continue;
                return false;
            }
            return true;
        }
        if (class2.isArray()) {
            return false;
        }
        return obj1.equals(obj2);
    }

    public boolean isEquals() {
        return this.equals;
    }
}

